@echo OFF
rem  *******************************************************************
echo ͻ
echo   xx.bat   New cycle batch file  (ARGUS/HELIX)             10/29/96
echo ͼ
rem           This file is executed during AUTO-CLOSE
rem           It is started by time or 99 report call
rem
rem           Uses clstart to setup closing schedule
rem
rem           Environmental variables used:
rem               helix         define HELIX system
rem               argus         define ARGUS system
rem               da,mo,yr,dw   business date / day from ORDER1.QUE creation
rem               cy            cycle to new week prior to merge
rem               newmo         cycle to new month prior to merge
rem               newqu         cycle to new quarter prior to merge
rem               newyr         cycle to new year prior to merge
rem               drnn          print report nn (daily format)
rem               crnn          print report nn (cycle format)
rem               nocl          skip closing this day
rem               endpp         end payroll period (weekly cycle)
rem               day           two letter day name based on dw
rem               fxnn          fixed options:
rem                                01 - auto print reports
rem                                02 - auto floppy disk write
rem                                03 - auto process inventory
rem                                04 - auto credit deposit
rem                                05 - shutdown file server during close
rem  *******************************************************************
rem  SETUP FOR ARGUS:      
set helix=0
set argus=1
REM echo *                     Check for skipped closing scheduled(DISABLED)
REM noclose
REM if errorlevel 1 goto exit
rem
echo ͻ
echo                   System suspended for reset...Please wait.      
echo ͼ
echo *                  Initialize cycle, completion log
del setenv.bat
del *.cmp
del *.lst
rem                                     Report to display
statset 1 CLOSE "Started. Not done" -ER
statset 2 Floppy "Backup NOT done!" -ER
echo *                                  Flash reports to disk (erased at end)
reqrpts 15
reqrpts 19
del dept7.que
rename dept6.que dept7.que
rename dept5.que dept6.que
rename dept4.que dept5.que
rename dept3.que dept4.que
rename dept2.que dept3.que
rename dept1.que dept2.que
echo *                                  Cycle system (wait for restart)
rem                                     Force cycle of ubill.que
reqrpts 53 0
rem
reqrpts 91
echo*                                   Wait for file server
waitfss
echo *                                  Setup date & day of week of data
echo *                                  from startup date on ORDER1.QUE
rem
clstart > setenv.bat
echo *                                  Check valid ORDER1.QUE
rem                                       1 .. missing, no header record
rem                                       2 .. already processed
rem                                       3 .. no schedule record
if errorlevel 3 goto level3
if errorlevel 2 goto level2
if errorlevel 1 goto level1
goto next
rem                                     Error level 1 ... exit
:level1
echo ͻ
echo                   Invalid order1.que                             
echo ͼ
statset 1 CLOSE "ERROR-Bad order.que" -ER
pause
goto exit
rem                                     Error level 2 ... exit
:level2
echo ͻ
echo                   Already Processed                              
echo ͼ
statset 1 CLOSE "ERROR-Already done" -ER
pause
goto exit
rem                                     Error level 3 ... exit
:level3
echo ͻ
echo                   No Schedule Record                             
echo ͼ
statset 1 CLOSE "ERROR-No sched" -ER
pause
goto exit
rem                                     OK ...continue
:next
rem                                     Setup environmental variabes
rem                                      DA,MO,YR,DW (DW = 1 .. Monday)
call setenv
echo *                                  Branch according to day of week
set day=
if %DW% == 1 goto day1
if %DW% == 2 goto day2
if %DW% == 3 goto day3
if %DW% == 4 goto day4
if %DW% == 5 goto day5
if %DW% == 6 goto day6
if %DW% == 7 goto day7
echo invalid day
goto exit
rem                                     Display day, set cycle & end week
:day1
echo ͻ
echo                   Monday   Closing Process                       
echo ͼ
set day=MO
goto cont
:day2
echo ͻ
echo                   Tuesday  Closing Process                       
echo ͼ
set day=TU
goto cont
:day3
echo ͻ
echo                   Wednesday Closing Process                      
echo ͼ
set day=WE
goto cont
:day4
echo ͻ
echo                   Thursday Closing Process                       
echo ͼ
set day=TH
goto cont
:day5
echo ͻ
echo                   Friday   Closing Process                       
echo ͼ
set day=FR
goto cont
:day6
echo ͻ
echo                   Saturday Closing Process                       
echo ͼ
set day=SA
goto cont
:day7
echo ͻ
echo                   Sunday   Closing Process                       
echo ͼ
set day=SU
goto cont
rem                                     Common processing
:cont
echo *                                   1 - Copy files & backup
call step1
if %fx05%~==~ goto s1
echo *                                   1A- Shut down file server
SLEEP 30
:s1
echo *                                   2 - New cycles & merge data
call step2
echo *                                   3 - Print audits
call step3
echo *                                   4 - Print sales reports
if %argus%==1  call step4a
if %helix%==1  call step4h
echo *                                   5 - Print time & historical reports
call step5
echo *                                   5c- Print customer specific reports
call step5c
echo *                                   6 - Create backup files
call step6
if %fx01%~==~ goto s8
echo *                                   7 - Print reports from spool files
call step7a
:s8
if %fx02%~==~ goto s9
echo *                                   8 - Backup files to floppy disk
call step8
:s9
echo *                                  Set process date to ORDER1.QUE
del orderx.que
hxend
statset 1 CLOSE "OK-finished"
echo *                                  Erase flash reports
del rp*.
echo *                                  Truncate credit card log
maxline cmn.log 100
if %fx05%~==~ goto exit
echo *                                  Restart file server
rem                                     Exit batch processing
:exit
echo *                                  CLOSING STEP STATUS:
wstatus
