/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.menu;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import org.primefaces.model.menu.DefaultMenuItem;
import org.primefaces.model.menu.DefaultMenuModel;
import org.primefaces.model.menu.DefaultSubMenu;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuModel;

@ManagedBean
public class MenuView {
    private MenuModel model;

    @PostConstruct
    public void init() {
        this.model = new DefaultMenuModel();
        DefaultSubMenu firstSubmenu = new DefaultSubMenu("Dynamic Submenu");
        DefaultMenuItem item = new DefaultMenuItem((Object)"External");
        item.setUrl("http://www.primefaces.org");
        item.setIcon("ui-icon-home");
        firstSubmenu.addElement((MenuElement)item);
        this.model.addElement((MenuElement)firstSubmenu);
        DefaultSubMenu secondSubmenu = new DefaultSubMenu("Dynamic Actions");
        item = new DefaultMenuItem((Object)"Save");
        item.setIcon("ui-icon-disk");
        item.setCommand("#{menuView.save}");
        item.setUpdate("messages");
        secondSubmenu.addElement((MenuElement)item);
        item = new DefaultMenuItem((Object)"Delete");
        item.setIcon("ui-icon-close");
        item.setCommand("#{menuView.delete}");
        item.setAjax(false);
        secondSubmenu.addElement((MenuElement)item);
        item = new DefaultMenuItem((Object)"Redirect");
        item.setIcon("ui-icon-search");
        item.setCommand("#{menuView.redirect}");
        secondSubmenu.addElement((MenuElement)item);
        this.model.addElement((MenuElement)secondSubmenu);
    }

    public MenuModel getModel() {
        return this.model;
    }

    public void save() {
        this.addMessage("Success", "Data saved");
    }

    public void update() {
        this.addMessage("Success", "Data updated");
    }

    public void delete() {
        this.addMessage("Success", "Data deleted");
    }

    public void addMessage(String summary, String detail) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, summary, detail);
        FacesContext.getCurrentInstance().addMessage(null, message);
    }
}

