/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.tree;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import org.primefaces.model.TreeNode;
import org.primefaces.ultima.service.DocumentService;

@ManagedBean(name="treeSelectionView")
@ViewScoped
public class SelectionView
implements Serializable {
    private TreeNode root1;
    private TreeNode root2;
    private TreeNode root3;
    private TreeNode selectedNode;
    private TreeNode[] selectedNodes1;
    private TreeNode[] selectedNodes2;
    @ManagedProperty(value="#{documentService}")
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root1 = this.service.createDocuments();
        this.root2 = this.service.createDocuments();
        this.root3 = this.service.createCheckboxDocuments();
    }

    public TreeNode getRoot1() {
        return this.root1;
    }

    public TreeNode getRoot2() {
        return this.root2;
    }

    public TreeNode getRoot3() {
        return this.root3;
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(TreeNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public TreeNode[] getSelectedNodes1() {
        return this.selectedNodes1;
    }

    public void setSelectedNodes1(TreeNode[] selectedNodes1) {
        this.selectedNodes1 = selectedNodes1;
    }

    public TreeNode[] getSelectedNodes2() {
        return this.selectedNodes2;
    }

    public void setSelectedNodes2(TreeNode[] selectedNodes2) {
        this.selectedNodes2 = selectedNodes2;
    }

    public void setService(DocumentService service) {
        this.service = service;
    }

    public void displaySelectedSingle() {
        if (this.selectedNode != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Selected", this.selectedNode.getData().toString());
            FacesContext.getCurrentInstance().addMessage(null, message);
        }
    }

    public void displaySelectedMultiple(TreeNode[] nodes) {
        if (nodes != null && nodes.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (TreeNode node : nodes) {
                builder.append(node.getData().toString());
                builder.append("<br />");
            }
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Selected", builder.toString());
            FacesContext.getCurrentInstance().addMessage(null, message);
        }
    }
}

