/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.datatable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.ultima.domain.Car;
import org.primefaces.ultima.service.CarService;
import org.primefaces.ultima.view.data.datatable.ColumnsView;

@ManagedBean(name="dtColumnsView")
@ViewScoped
public class ColumnsView
implements Serializable {
    private static final List<String> VALID_COLUMN_KEYS = Arrays.asList("id", "brand", "year", "color", "price");
    private String columnTemplate = "id brand year";
    private List<ColumnModel> columns;
    private List<Car> cars;
    private List<Car> filteredCars;
    @ManagedProperty(value="#{carService}")
    private CarService service;

    @PostConstruct
    public void init() {
        this.cars = this.service.createCars(10);
        this.createDynamicColumns();
    }

    public List<Car> getCars() {
        return this.cars;
    }

    public List<Car> getFilteredCars() {
        return this.filteredCars;
    }

    public void setFilteredCars(List<Car> filteredCars) {
        this.filteredCars = filteredCars;
    }

    public void setService(CarService service) {
        this.service = service;
    }

    public String getColumnTemplate() {
        return this.columnTemplate;
    }

    public void setColumnTemplate(String columnTemplate) {
        this.columnTemplate = columnTemplate;
    }

    public List<ColumnModel> getColumns() {
        return this.columns;
    }

    private void createDynamicColumns() {
        String[] columnKeys = this.columnTemplate.split(" ");
        this.columns = new ArrayList();
        for (String columnKey : columnKeys) {
            String key = columnKey.trim();
            if (!VALID_COLUMN_KEYS.contains(key)) continue;
            this.columns.add(new ColumnModel(columnKey.toUpperCase(), columnKey));
        }
    }

    public void updateColumns() {
        UIComponent table = FacesContext.getCurrentInstance().getViewRoot().findComponent(":form:cars");
        table.setValueExpression("sortBy", null);
        this.createDynamicColumns();
    }
}

