/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.primefaces.event.ScheduleEntryMoveEvent;
import org.primefaces.event.ScheduleEntryResizeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.DefaultScheduleEvent;
import org.primefaces.model.DefaultScheduleModel;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;

@ManagedBean
@ViewScoped
public class ScheduleView
implements Serializable {
    private ScheduleModel eventModel;
    private ScheduleModel lazyEventModel;
    private ScheduleEvent event = new DefaultScheduleEvent();

    @PostConstruct
    public void init() {
        this.eventModel = new DefaultScheduleModel();
        this.eventModel.addEvent((ScheduleEvent)new DefaultScheduleEvent("Champions League Match", this.previousDay8Pm(), this.previousDay11Pm()));
        this.eventModel.addEvent((ScheduleEvent)new DefaultScheduleEvent("Birthday Party", this.today1Pm(), this.today6Pm()));
        this.eventModel.addEvent((ScheduleEvent)new DefaultScheduleEvent("Breakfast at Tiffanys", this.nextDay9Am(), this.nextDay11Am()));
        this.eventModel.addEvent((ScheduleEvent)new DefaultScheduleEvent("Plant the new garden stuff", this.theDayAfter3Pm(), this.fourDaysLater3pm()));
        this.lazyEventModel = new /* Unavailable Anonymous Inner Class!! */;
    }

    public Date getRandomDate(Date base) {
        Calendar date = Calendar.getInstance();
        date.setTime(base);
        date.add(5, (int)(Math.random() * 30.0) + 1);
        return date.getTime();
    }

    public Date getInitialDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), 1, calendar.get(5), 0, 0, 0);
        return calendar.getTime();
    }

    public ScheduleModel getEventModel() {
        return this.eventModel;
    }

    public ScheduleModel getLazyEventModel() {
        return this.lazyEventModel;
    }

    private Calendar today() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        return calendar;
    }

    private Date previousDay8Pm() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 1);
        t.set(5, t.get(5) - 1);
        t.set(10, 8);
        return t.getTime();
    }

    private Date previousDay11Pm() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 1);
        t.set(5, t.get(5) - 1);
        t.set(10, 11);
        return t.getTime();
    }

    private Date today1Pm() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 1);
        t.set(10, 1);
        return t.getTime();
    }

    private Date theDayAfter3Pm() {
        Calendar t = (Calendar)this.today().clone();
        t.set(5, t.get(5) + 2);
        t.set(9, 1);
        t.set(10, 3);
        return t.getTime();
    }

    private Date today6Pm() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 1);
        t.set(10, 6);
        return t.getTime();
    }

    private Date nextDay9Am() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 0);
        t.set(5, t.get(5) + 1);
        t.set(10, 9);
        return t.getTime();
    }

    private Date nextDay11Am() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 0);
        t.set(5, t.get(5) + 1);
        t.set(10, 11);
        return t.getTime();
    }

    private Date fourDaysLater3pm() {
        Calendar t = (Calendar)this.today().clone();
        t.set(9, 1);
        t.set(5, t.get(5) + 4);
        t.set(10, 3);
        return t.getTime();
    }

    public ScheduleEvent getEvent() {
        return this.event;
    }

    public void setEvent(ScheduleEvent event) {
        this.event = event;
    }

    public void addEvent(ActionEvent actionEvent) {
        if (this.event.getId() == null) {
            this.eventModel.addEvent(this.event);
        } else {
            this.eventModel.updateEvent(this.event);
        }
        this.event = new DefaultScheduleEvent();
    }

    public void onEventSelect(SelectEvent selectEvent) {
        this.event = (ScheduleEvent)selectEvent.getObject();
    }

    public void onDateSelect(SelectEvent selectEvent) {
        this.event = new DefaultScheduleEvent("", (Date)selectEvent.getObject(), (Date)selectEvent.getObject());
    }

    public void onEventMove(ScheduleEntryMoveEvent event) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event moved", "Day delta:" + event.getDayDelta() + ", Minute delta:" + event.getMinuteDelta());
        this.addMessage(message);
    }

    public void onEventResize(ScheduleEntryResizeEvent event) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event resized", "Day delta:" + event.getDayDelta() + ", Minute delta:" + event.getMinuteDelta());
        this.addMessage(message);
    }

    private void addMessage(FacesMessage message) {
        FacesContext.getCurrentInstance().addMessage(null, message);
    }
}

