/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.context.FacesContext;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.TransferEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.model.DualListModel;
import org.primefaces.ultima.domain.Theme;
import org.primefaces.ultima.service.ThemeService;

@ManagedBean
public class PickListView {
    @ManagedProperty(value="#{themeService}")
    private ThemeService service;
    private DualListModel<String> cities;
    private DualListModel<Theme> themes;

    @PostConstruct
    public void init() {
        ArrayList<String> citiesSource = new ArrayList<String>();
        ArrayList citiesTarget = new ArrayList();
        citiesSource.add("San Francisco");
        citiesSource.add("London");
        citiesSource.add("Paris");
        citiesSource.add("Istanbul");
        citiesSource.add("Berlin");
        citiesSource.add("Barcelona");
        citiesSource.add("Rome");
        this.cities = new DualListModel(citiesSource, citiesTarget);
        List themesSource = this.service.getThemes().subList(0, 6);
        ArrayList themesTarget = new ArrayList();
        this.themes = new DualListModel(themesSource, themesTarget);
    }

    public DualListModel<String> getCities() {
        return this.cities;
    }

    public void setCities(DualListModel<String> cities) {
        this.cities = cities;
    }

    public ThemeService getService() {
        return this.service;
    }

    public void setService(ThemeService service) {
        this.service = service;
    }

    public DualListModel<Theme> getThemes() {
        return this.themes;
    }

    public void setThemes(DualListModel<Theme> themes) {
        this.themes = themes;
    }

    public void onTransfer(TransferEvent event) {
        StringBuilder builder = new StringBuilder();
        for (Object item : event.getItems()) {
            builder.append(((Theme)item).getName()).append("<br />");
        }
        FacesMessage msg = new FacesMessage();
        msg.setSeverity(FacesMessage.SEVERITY_INFO);
        msg.setSummary("Items Transferred");
        msg.setDetail(builder.toString());
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public void onSelect(SelectEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Item Selected", event.getObject().toString()));
    }

    public void onUnselect(UnselectEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Item Unselected", event.getObject().toString()));
    }

    public void onReorder() {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "List Reordered", null));
    }
}

