/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.service;

import com.certuit.cercana.domain.entity.Cardex;
import com.certuit.cercana.domain.entity.CardexTab;
import com.certuit.cercana.domain.entity.Cuenta;
import com.certuit.cercana.domain.entity.CuentaTab;
import com.certuit.cercana.domain.entity.vistas.EstrategiaPrecios;
import com.certuit.cercana.domain.entity.vistas.PLUVista;
import com.certuit.cercana.domain.entity.vistas.TabIvaVista;
import com.certuit.cercana.repositories.CardexRepository;
import com.certuit.cercana.repositories.CardexTabRepository;
import com.certuit.cercana.repositories.CuentaRepository;
import com.certuit.cercana.repositories.CuentaTabRepository;
import com.certuit.cercana.repositories.EstrategiaPreciosRepository;
import com.certuit.cercana.repositories.TabIvaRepository;
import com.certuit.cercana.service.CuentaService;
import com.certuit.cercana.service.CuentaTabService;
import com.certuit.cercana.service.PLUService;
import com.certuit.cercana.service.ParametrosGService;
import com.certuit.cercana.service.base.ServiceBase;
import com.certuit.cercana.util.TimeDateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class CardexService
extends ServiceBase<Cardex, Integer> {
    @Autowired
    private CardexRepository cardexRepository;
    @Autowired
    private CardexTabRepository cardexTabRepository;
    @Autowired
    private CuentaTabRepository cuentaTabRepository;
    @Autowired
    private CuentaRepository cuentaRepository;
    @Autowired
    private EstrategiaPreciosRepository estrategiaPreciosRepository;
    @Autowired
    private TabIvaRepository tabIvaRepository;
    @Autowired
    private PLUService pluService;
    @Autowired
    private CuentaService cuentaService;
    @Autowired
    private CuentaTabService cuentaTabService;
    @Autowired
    private ParametrosGService parametrosGService;

    public CardexService(CrudRepository<Cardex, Integer> repo) {
        super(repo);
    }

    public List<Cardex> getCardexesByCuenta(Integer cuentaId) {
        List cardexes = this.cardexRepository.findAllByCuentaPerteneciente(cuentaId);
        for (Cardex cardex : cardexes) {
            if (cardex.getPluId() == null) continue;
            cardex.setPlu((PLUVista)this.pluService.findOne((Serializable)((Object)cardex.getPluId())));
        }
        return cardexes;
    }

    public Cuenta ordenarCuenta(Cuenta cuenta, String plus, String pos, String empOrd, String cantidades, String cambios) {
        String[] plusIds = plus.split(",");
        int cont = 0;
        boolean isCombo = false;
        int comboItems = 0;
        String[] modCambios = cambios.split(",");
        String[] cantidadesInd = cantidades.split(",");
        String comboName = "";
        CuentaTab cuentaTableta = new CuentaTab();
        cuentaTableta.setCuenta(cuenta.getCuenta());
        cuentaTableta.setEmpleadoOrd(empOrd);
        cuentaTableta.setPersonas(cuenta.getNumPersonas().intValue());
        cuentaTableta.setNotas(1);
        cuentaTableta.setPos(pos);
        cuentaTableta.setTipo(1);
        cuentaTableta.setEstado("0");
        cuentaTableta.setTabCliente("");
        this.cuentaTabRepository.save((Object)cuentaTableta);
        for (int i = 0; i < plusIds.length; ++i) {
            PLUVista pluVista = (PLUVista)this.pluService.findOne((Serializable)((Object)plusIds[i]));
            double[] pluPrices = new double[]{pluVista.getPrecio1(), pluVista.getPrecio2(), pluVista.getPrecio3(), pluVista.getPrecio4(), pluVista.getPrecio5(), pluVista.getPrecio6(), pluVista.getPrecio7(), pluVista.getPrecio8(), pluVista.getPrecio9()};
            if (pluVista == null || pluVista.isCategory()) continue;
            Cardex cardex = new Cardex();
            CardexTab cardexTablet = new CardexTab();
            if (modCambios.length != 0 && pluVista.getId().equals("88990") || modCambios.length != 0 && pluVista.getMod().equals("1")) {
                cardex.setNombreCorto(modCambios[cont]);
                cardex.setNombreLargo(modCambios[cont]);
                cardexTablet.setNomL("   " + modCambios[cont]);
                cardex.setCan(new BigDecimal(0));
                cardexTablet.setCantidad(0);
                ++cont;
            } else if (isCombo) {
                if (this.parametrosGService.descriptionNeeded()) {
                    cardex.setNombreCorto(pluVista.getNombreCorto());
                    cardex.setNombreLargo(pluVista.getNombreLargo() + "\n  *" + comboName + "*");
                    cardexTablet.setNomL("   " + pluVista.getNombreLargo() + "\n  *" + comboName + "*");
                } else {
                    cardex.setNombreCorto(pluVista.getNombreCorto());
                    cardex.setNombreLargo(pluVista.getNombreLargo());
                    cardexTablet.setNomL("   " + pluVista.getNombreLargo());
                }
                cardex.setCan(new BigDecimal(Integer.parseInt(cantidadesInd[i])));
                cardexTablet.setCantidad(Integer.parseInt(cantidadesInd[i]));
                if (comboItems == 1) {
                    isCombo = false;
                    comboName = "";
                }
                --comboItems;
            } else if (pluVista.getVec().charAt(21) == '1') {
                cardex.setNombreLargo(pluVista.getNombreCorto());
                cardex.setNombreCorto(pluVista.getNombreCorto());
                cardexTablet.setNomL(pluVista.getNombreCorto());
                cardex.setCan(new BigDecimal(Integer.parseInt(cantidadesInd[i])));
                cardexTablet.setCantidad(Integer.parseInt(cantidadesInd[i]));
                comboItems = pluVista.getNombreLargo().split(";").length;
                comboName = pluVista.getNombreCorto().toLowerCase();
                isCombo = true;
            } else {
                cardex.setNombreCorto(pluVista.getNombreCorto());
                cardex.setNombreLargo(pluVista.getNombreLargo());
                cardexTablet.setNomL(pluVista.getNombreLargo());
                cardex.setCan(new BigDecimal(Integer.parseInt(cantidadesInd[i])));
                cardexTablet.setCantidad(Integer.parseInt(cantidadesInd[i]));
            }
            cardex.setCuentaPerteneciente(cuenta.getId());
            cardex.setHora(TimeDateUtils.getTime());
            cardex.setFecha(TimeDateUtils.getTodayDate());
            cardex.setPos(pos);
            cardex.setCuentaId(cuenta.getCuenta());
            cardex.setNot(Integer.valueOf(1));
            cardex.setStaEnv("s");
            if (this.getPriceByEstrategy(pos) != -1) {
                cardex.setUni(new BigDecimal(pluPrices[this.getPriceByEstrategy(pos) - 1]));
                cardex.setSub(new BigDecimal(pluPrices[this.getPriceByEstrategy(pos) - 1] * (double)Integer.parseInt(cantidadesInd[i])));
            } else {
                cardex.setUni(new BigDecimal(pluVista.getPrecio1()));
                cardex.setSub(new BigDecimal(pluVista.getPrecio1() * (double)Integer.parseInt(cantidadesInd[i])));
            }
            cardex.setVod(".");
            cardex.setCanceladoGerente(".");
            cardex.setHoraCancelado(".");
            cardex.setPluId(plusIds[i]);
            cardex.setIva(new BigDecimal(0));
            cardex.setAbr(cuenta.getEmpleadoAbridorNum());
            cardex.setOrd(empOrd);
            cardex.setLoc(cuenta.getLocacion());
            cardex.setMca(".");
            cardex.setReo("1");
            cardex.setVodImp("0");
            cardex.setStatusAbierto("0");
            cardex.setTabIva("0");
            cardex.setFwd("0");
            cardex.setStaCort("0");
            cardex.setBono("0");
            cardex.setSubCalc(new BigDecimal(0));
            cardex.setIvaCalc(new BigDecimal(0));
            cardex.setDscCalc(new BigDecimal(0));
            cardexTablet.setNumeroPlu(pluVista.getId());
            cardexTablet.setCveCuenta(cuentaTableta.getId());
            this.cardexRepository.save((Object)cardex);
            this.cardexTabRepository.save((Object)cardexTablet);
        }
        Cuenta cuentaToUpdate = (Cuenta)this.cuentaService.findOne((Serializable)cuenta.getId());
        cuentaToUpdate.setEnv(Integer.valueOf(cuenta.getEnv() + 1));
        this.cuentaRepository.save((Object)cuenta);
        return cuenta;
    }

    public double addIva(String tablaIva, double price) {
        double ivaToAdd = 0.0;
        double priceIvaAdded = 0.0;
        List ivas = this.tabIvaRepository.findAll();
        for (TabIvaVista iva : ivas) {
            if (!iva.getId().equals(tablaIva)) continue;
            ivaToAdd = iva.getPorcentaje();
            priceIvaAdded = price * ivaToAdd / 100.0;
        }
        return priceIvaAdded;
    }

    private int getWeekDay() {
        String diaActual = LocalDate.now().getDayOfWeek().name();
        int diaActualNumero = 0;
        switch (diaActual) {
            case "MONDAY": {
                diaActualNumero = 1;
                break;
            }
            case "TUESDAY": {
                diaActualNumero = 2;
                break;
            }
            case "WEDNESDAY": {
                diaActualNumero = 3;
                break;
            }
            case "THURSDAY": {
                diaActualNumero = 4;
                break;
            }
            case "FRIDAY": {
                diaActualNumero = 5;
                break;
            }
            case "SATURDAY": {
                diaActualNumero = 6;
                break;
            }
            case "SUNDAY": {
                diaActualNumero = 7;
            }
        }
        return diaActualNumero;
    }

    private int filterActualHour(String hr) {
        String[] hour = hr.split(":");
        return Integer.parseInt(hour[0]);
    }

    private int filterActualMinutes(String hr) {
        String[] hour = hr.split(":");
        return Integer.parseInt(hour[1]);
    }

    private int actualHour() {
        LocalTime time = LocalTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String completeTime = time.format(formatter);
        String[] hour = completeTime.split(":");
        return Integer.parseInt(hour[0]);
    }

    private int actualMinutes() {
        LocalTime time = LocalTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String completeTime = time.format(formatter);
        String[] hour = completeTime.split(":");
        return Integer.parseInt(hour[1]);
    }

    private boolean isInTimeRange(String hr1, String hr2) {
        boolean flag = false;
        int initHour = this.filterActualHour(hr1);
        int initMin = this.filterActualMinutes(hr1);
        int finalHour = this.filterActualHour(hr2);
        int finalMin = this.filterActualMinutes(hr2);
        if (this.actualHour() >= initHour && this.actualMinutes() >= initMin && this.actualHour() <= finalHour && this.actualMinutes() <= finalMin) {
            flag = true;
        }
        return flag;
    }

    public int getPriceByEstrategy(String pos) {
        List peps = this.estrategiaPreciosRepository.findAllByPos(pos);
        int tablaPrecios = -1;
        for (EstrategiaPrecios pep : peps) {
            if (!this.isInTimeRange(pep.getHoraInicio(), pep.getHoraFinal()) || pep.getDiaSemana() != this.getWeekDay()) continue;
            tablaPrecios = pep.getTablaPrecios();
        }
        return tablaPrecios;
    }
}

