/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.endpoint;

import com.certuit.cercana.domain.entity.vistas.ItemTableroVista;
import com.certuit.cercana.domain.entity.vistas.PLUVista;
import com.certuit.cercana.domain.entity.vistas.TableroVista;
import com.certuit.cercana.domain.wrappers.TableroCuadroWrapper;
import com.certuit.cercana.domain.wrappers.TableroWrapper;
import com.certuit.cercana.exception.EntityNotFoundException;
import com.certuit.cercana.service.ItemTableroService;
import com.certuit.cercana.service.PLUService;
import com.certuit.cercana.service.TableroService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tableros"})
public class TableroRest {
    @Autowired
    private TableroService tableroService;
    @Autowired
    private ItemTableroService itemTableroService;
    @Autowired
    private PLUService pluService;

    @GetMapping
    public List<TableroVista> getAllTableros() {
        return this.tableroService.findAll();
    }

    @GetMapping(value={"/{tableroId}"})
    public List<TableroWrapper> getTablero(@PathVariable String tableroId) {
        List itemTableroVistas = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, false);
        List categorias = this.pluService.getAllCategories();
        ArrayList<TableroWrapper> tableroWrappers = new ArrayList<TableroWrapper>();
        for (PLUVista categoria : categorias) {
            TableroWrapper tableroWrapper = null;
            for (ItemTableroVista itemTableroVista : itemTableroVistas) {
                if (itemTableroVista.getPluId() == null) continue;
                boolean isAlreadyInList = false;
                if (tableroWrapper != null && tableroWrapper.getItemsTablero() != null) {
                    for (ItemTableroVista itemTableroVistaList : tableroWrapper.getItemsTablero()) {
                        if (itemTableroVistaList.getPluId() == null || !itemTableroVistaList.getPluId().equalsIgnoreCase(itemTableroVista.getPluId())) continue;
                        isAlreadyInList = true;
                        break;
                    }
                }
                if (isAlreadyInList || !categoria.getId().trim().equalsIgnoreCase(itemTableroVista.getPluId().trim().substring(0, 1))) continue;
                if (tableroWrapper == null) {
                    tableroWrapper = new TableroWrapper();
                }
                if (tableroWrapper.getCategoria() == null) {
                    tableroWrapper.setCategoria(categoria);
                }
                if (tableroWrapper.getItemsTablero() == null) {
                    tableroWrapper.setItemsTablero(new ArrayList());
                }
                itemTableroVista.setCategoriaPLU(categoria);
                itemTableroVista.setPluVista((PLUVista)this.pluService.findOne((Serializable)((Object)itemTableroVista.getPluId())));
                if (itemTableroVista.getImg() != null) {
                    itemTableroVista.setImg(itemTableroVista.getImg().trim());
                    if (itemTableroVista.getImg().substring(itemTableroVista.getImg().lastIndexOf(46)).equalsIgnoreCase(".BMP")) {
                        itemTableroVista.setImg(null);
                    }
                }
                tableroWrapper.getItemsTablero().add(itemTableroVista);
            }
            if (tableroWrapper == null) continue;
            tableroWrappers.add(tableroWrapper);
        }
        return tableroWrappers;
    }

    @GetMapping(value={"/android/{tableroId}"})
    public List<TableroCuadroWrapper> getTableroAndroid(@PathVariable(value="tableroId") String tableroId) {
        TableroVista tablero = (TableroVista)this.tableroService.findOne((Serializable)((Object)tableroId));
        if (tablero != null) {
            List itemsTablero = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, true);
            return this.tableroService.transformTablero(tablero, itemsTablero);
        }
        throw new EntityNotFoundException("El tablero solicitado no fue encontrado");
    }

    @GetMapping(value={"/secondBoard/{tableroId}"})
    public List<TableroCuadroWrapper> getSecondTableroAndroid(@PathVariable(value="tableroId") String tableroId) {
        TableroVista tablero = (TableroVista)this.tableroService.findOne((Serializable)((Object)tableroId));
        if (tablero != null) {
            List itemsTablero = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, true);
            return this.tableroService.transformSecondTablero(tablero, itemsTablero);
        }
        throw new EntityNotFoundException("El tablero solicitado no fue encontrado");
    }
}

