/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.endpoint;

import com.certuit.cercana.domain.entity.vistas.PLUVista;
import com.certuit.cercana.repositories.PLURepository;
import com.certuit.cercana.service.CardexService;
import com.certuit.cercana.service.PLUService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/plu"})
public class PLURest {
    @Autowired
    private PLURepository pluRepository;
    @Autowired
    private PLUService pluService;
    @Autowired
    private CardexService cardexService;

    @GetMapping
    public List<PLUVista> getAllPLUS() {
        return this.pluService.getAllPLUS();
    }

    @GetMapping(value={"/categorias"})
    public List<PLUVista> getAllCategories() {
        return this.pluService.getAllCategories();
    }

    @GetMapping(value={"/sub-categorias"})
    public List<PLUVista> getAllSubCategories() {
        return this.pluService.getAllSubCategories();
    }

    @GetMapping(value={"/{pos}"})
    public int getPriceByEstrategy(@PathVariable String pos) {
        return this.cardexService.getPriceByEstrategy(pos);
    }
}

