/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.endpoint;

import com.certuit.cercana.domain.entity.Cuenta;
import com.certuit.cercana.exception.CuentaNoAbiertaException;
import com.certuit.cercana.exception.EntityException;
import com.certuit.cercana.exception.EntityExistsException;
import com.certuit.cercana.exception.EntityNotFoundException;
import com.certuit.cercana.service.CardexService;
import com.certuit.cercana.service.CuentaService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cuenta"})
public class CuentaRest {
    @Autowired
    private CuentaService cuentaService;
    @Autowired
    CardexService cardexService;

    @GetMapping(value={"/{meseroId}"})
    public List<Cuenta> getCuentasByMesero(@PathVariable(value="meseroId") String meseroId) {
        return this.cuentaService.getCuentasByMesero(meseroId);
    }

    @GetMapping
    public List<Cuenta> getAllAccounts() {
        return this.cuentaService.getAllCuentas();
    }

    @PostMapping(value={"/abrir"})
    public ResponseEntity<Cuenta> abrirCuenta(@RequestParam(value="num_cuenta") String numCuenta, @RequestParam(value="num_empleado") String empleadoNum, @RequestParam(name="num_personas", required=false) Integer numeroPersonas, @RequestParam(name="pos", required=false) String pos, @RequestParam(name="num_notas", required=false) Integer numeroNotas, @RequestParam(name="nombre_cuenta", required=false) String nombreCuenta) {
        Cuenta cuenta = this.cuentaService.getCuenta(numCuenta);
        if (cuenta == null) {
            Cuenta newCuenta = this.cuentaService.saveCuenta(numCuenta, empleadoNum, pos, nombreCuenta, numeroPersonas.intValue(), numeroNotas.intValue());
            if (newCuenta != null) {
                return new ResponseEntity((Object)newCuenta, HttpStatus.OK);
            }
            throw new EntityException("Ha ocurrido un error al abrir esta cuenta. Contacte con soporte t\u00e9cnico.");
        }
        throw new EntityExistsException("La cuenta que desea abrir ya se encuentra abierta");
    }

    @PostMapping(value={"/{cuenta_id}/ordenar"})
    public Cuenta ordenarCuenta(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="plus") String plus, @RequestParam(name="pos", required=false) String pos, @RequestParam(value="emp_ord") String empOrd, @RequestParam(value="cantidades") String cantidades, @RequestParam(value="cambios") String cambios) {
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta != null) {
            String status = cuenta.getSta();
            if (status != null && status.equalsIgnoreCase("0")) {
                return this.cardexService.ordenarCuenta(cuenta, plus, pos, empOrd, cantidades, cambios);
            }
            throw new CuentaNoAbiertaException("La cuenta en la que intenta ordenar est\u00e1 abierta");
        }
        throw new EntityNotFoundException("La cuenta en la que intenta ordenar no existe.");
    }
}

