/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.EmpleadoVista;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.service.EmpleadoService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/empleado"})
public class EmpleadoRest {
    @Autowired
    private EmpleadoService empleadoService;

    @GetMapping
    public List<EmpleadoVista> getAllEmpleados() {
        return this.empleadoService.getAllEmpleados();
    }

    @GetMapping(value={"/byId/{idEmployee}"})
    public EmpleadoVista getEmpleado(@PathVariable(value="idEmployee") String id) {
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)id));
        if (empleado != null) {
            return empleado;
        }
        throw new EntityNotFoundException("Empleado no encontrado");
    }

    @PostMapping(value={"login"})
    public EmpleadoVista loginEmpleado(@RequestParam(value="num_empleado") String empleadoId, @RequestParam(value="pos") String pos, @RequestParam(value="ipTablet") String ipTablet) throws Exception {
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)empleadoId));
        if (empleado != null) {
            if (empleado.getStatus() == 0 || empleado.getStatus() != 0) {
                if (empleado.getTurno() == 1) {
                    if (this.posAuth(empleado.getVec_emp_pos(), pos)) {
                        empleado.setStatus(1);
                        this.empleadoService.save((Object)empleado);
                        return empleado;
                    }
                    throw new Exception("Terminal NO Autorizada para el empleado: " + empleadoId);
                }
                throw new EntityNotFoundException("El empleado con n\u00famero: " + empleadoId + " no est\u00e1 en turno");
            }
            throw new Exception("El empleado con el n\u00famero: " + empleadoId + " ya est\u00e1 ordenando");
        }
        throw new EntityNotFoundException("El empleado con n\u00famero: " + empleadoId + " no fue encontrado");
    }

    @PostMapping(value={"logout"})
    public EmpleadoVista logoutEmpleado(@RequestParam(value="num_empleado") String empleadoId, @RequestParam(value="pos") String pos, @RequestParam(value="ipTablet") String ipTablet) throws Exception {
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)empleadoId));
        if (empleado != null) {
            empleado.setStatus(0);
            this.empleadoService.save((Object)empleado);
        }
        return empleado;
    }

    private boolean posAuth(String posVec, String pos) {
        return posVec.charAt(Integer.parseInt(pos) - 1) != '1';
    }

    @PostMapping(value={"seg"})
    public EmpleadoVista obtenerEmpleado(@RequestParam(value="num_empleado") String empleadoId, @RequestParam(value="password") String pass) {
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)empleadoId));
        String contra = empleado.getContrasena().trim();
        if (contra.equals(pass) && empleado.getAutorizacion().equals("9")) {
            return empleado;
        }
        throw new EntityNotFoundException("La contrase\u00f1a no coincide o no tiene autorizaci\u00f3n");
    }
}

