/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.config;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(entityManagerFactoryRef="entityManagerFactory", basePackages={"com.sierra.pdv.repositories"})
public class AppDbConfig {
    @Primary
    @Bean(name={"dataSource"})
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder builder, @Qualifier(value="dataSource") DataSource dataSource) {
        return builder.dataSource(dataSource).packages(new String[]{"com.sierra.pdv.domain.entity"}).persistenceUnit("entity").properties(this.jpaProperties()).build();
    }

    @Primary
    @Bean(name={"transactionManager"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManagerFactory") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

    protected Map<String, Object> jpaProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("hibernate.hbm2ddl.auto", "none");
        return props;
    }
}

