/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.service;

import com.sierra.pdv.domain.entity.Cardex;
import com.sierra.pdv.domain.entity.CardexTab;
import com.sierra.pdv.domain.entity.Cuenta;
import com.sierra.pdv.domain.entity.CuentaTab;
import com.sierra.pdv.domain.entity.CuentaTabX;
import com.sierra.pdv.domain.entity.ParametrosG;
import com.sierra.pdv.domain.entity.vistas.EstrategiaPrecios;
import com.sierra.pdv.domain.entity.vistas.PLUVista;
import com.sierra.pdv.domain.entity.vistas.TabIvaVista;
import com.sierra.pdv.domain.request.CancelacionRequest;
import com.sierra.pdv.domain.request.CancelacionesRequest;
import com.sierra.pdv.domain.request.OrdenRequest;
import com.sierra.pdv.domain.request.PluRequest;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.repositories.CardexRepository;
import com.sierra.pdv.repositories.CardexTabRepository;
import com.sierra.pdv.repositories.CuentaRepository;
import com.sierra.pdv.repositories.CuentaTabRepository;
import com.sierra.pdv.repositories.CuentaTabXRepository;
import com.sierra.pdv.repositories.EstrategiaPreciosRepository;
import com.sierra.pdv.repositories.IepsRepository;
import com.sierra.pdv.repositories.TabIvaRepository;
import com.sierra.pdv.service.CuentaService;
import com.sierra.pdv.service.PLUService;
import com.sierra.pdv.service.ParametrosGService;
import com.sierra.pdv.service.base.ServiceBase;
import com.sierra.pdv.util.TimeDateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class CardexService
extends ServiceBase<Cardex, Integer> {
    @Autowired
    private CardexRepository cardexRepository;
    @Autowired
    private CardexTabRepository cardexTabRepository;
    @Autowired
    private CuentaTabRepository cuentaTabRepository;
    @Autowired
    private CuentaTabXRepository cuentaTabXRepository;
    @Autowired
    private CuentaRepository cuentaRepository;
    @Autowired
    private EstrategiaPreciosRepository estrategiaPreciosRepository;
    @Autowired
    private TabIvaRepository tabIvaRepository;
    @Autowired
    private PLUService pluService;
    @Autowired
    private CuentaService cuentaService;
    @Autowired
    private IepsRepository iepsRepository;
    @Autowired
    private ParametrosGService parametrosGService;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public CardexService(CrudRepository<Cardex, Integer> repo) {
        super(repo);
    }

    public List<Cardex> getCardexesByCuenta(Integer cuentaId) {
        List cardexes = this.cardexRepository.findAllByCuentaPerteneciente(cuentaId);
        cardexes.sort(Comparator.comparingInt(Cardex::getId));
        for (Cardex cardex : cardexes) {
            if (cardex.getPluId() == null) continue;
            cardex.setPlu((PLUVista)this.pluService.findOne((Serializable)((Object)cardex.getPluId())));
        }
        return cardexes;
    }

    public Cuenta ordenarCuenta(Cuenta cuenta, OrdenRequest orden) {
        boolean existIepsColumn = false;
        BigDecimal subTotal = new BigDecimal(0.0);
        double iepsTotal = 0.0;
        CuentaTab cuentaTableta = new CuentaTab();
        cuentaTableta.setId(Integer.valueOf(this.cuentaTabRepository.getFolio()));
        cuentaTableta.setCuenta(cuenta.getCuenta());
        cuentaTableta.setEmpleadoOrd(orden.getEmpOrd());
        cuentaTableta.setPersonas(cuenta.getNumPersonas().intValue());
        cuentaTableta.setNotas(cuenta.getNumNotas().intValue());
        cuentaTableta.setPos(orden.getPos());
        cuentaTableta.setTipo(cuenta.getTipo().intValue());
        cuentaTableta.setEstado("0");
        cuentaTableta.setTabCliente(cuenta.getCliente());
        cuentaTableta.setVta(Integer.valueOf(1));
        List parametrosG = this.parametrosGService.getAllGralParams();
        String vector = "";
        if (!parametrosG.isEmpty()) {
            vector = ((ParametrosG)parametrosG.get(0)).getVecPdv();
        }
        for (int i = 0; i < orden.getPLUs().size(); ++i) {
            BigDecimal subBD;
            Double sub;
            double cantidad = Double.parseDouble(((PluRequest)orden.getPLUs().get(i)).getQuantity());
            int cantidadint = (int)cantidad;
            Cardex cardex = new Cardex();
            CardexTab cardexTablet = new CardexTab();
            cardex.setNombreCorto(((PluRequest)orden.getPLUs().get(i)).getNombreCorto());
            cardex.setNombreLargo(((PluRequest)orden.getPLUs().get(i)).getNombreLargo());
            if (vector.length() > 98) {
                if (vector.charAt(99) != '1') {
                    cardexTablet.setNomL(((PluRequest)orden.getPLUs().get(i)).getNombreLargo());
                } else {
                    cardexTablet.setNomL(((PluRequest)orden.getPLUs().get(i)).getNombreCorto());
                }
            } else {
                cardexTablet.setNomL(((PluRequest)orden.getPLUs().get(i)).getNombreLargo());
            }
            cardex.setCan(new BigDecimal(cantidad));
            cardexTablet.setCantidad(cantidadint);
            cardex.setCuentaPerteneciente(cuenta.getId());
            cardex.setHora(TimeDateUtils.getTime());
            cardex.setFecha(TimeDateUtils.getTodayDate());
            cardex.setPos(orden.getPos());
            cardex.setCuentaId(cuenta.getCuenta());
            cardex.setNot(Integer.valueOf(((PluRequest)orden.getPLUs().get(i)).getNota()));
            cardex.setStaEnv("s");
            if (this.getPriceByEstrategy(orden.getPos()) != -1) {
                if (!((PluRequest)orden.getPLUs().get(i)).getVec().isEmpty() || ((PluRequest)orden.getPLUs().get(i)).getVec() != null) {
                    cardex.setUni(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice()));
                    cardex.setSub(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice() * (double)cantidadint));
                    subTotal = subTotal.add(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice() * (double)cantidadint));
                } else if (this.isOpenPLU(((PluRequest)orden.getPLUs().get(i)).getVec())) {
                    BigDecimal uni = new BigDecimal(0);
                    cardex.setUni(uni);
                    sub = uni.doubleValue() * cardex.getCan().doubleValue();
                    cardex.setSub(new BigDecimal(sub));
                    subTotal = subTotal.add(new BigDecimal(sub));
                } else {
                    cardex.setUni(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice()));
                    cardex.setSub(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice() * (double)cantidadint));
                    subTotal = subTotal.add(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice() * (double)cantidadint));
                }
            } else if (!((PluRequest)orden.getPLUs().get(i)).getVec().isEmpty() || ((PluRequest)orden.getPLUs().get(i)).getVec() != null) {
                cardex.setUni(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice()));
                Double sub2 = Double.valueOf(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice()) * Double.valueOf(cardex.getCan().toString());
                subBD = new BigDecimal(sub2);
                subTotal = subTotal.add(subBD);
                cardex.setSub(new BigDecimal(sub2));
            } else if (this.isOpenPLU(((PluRequest)orden.getPLUs().get(i)).getVec())) {
                BigDecimal uni = new BigDecimal(0);
                cardex.setUni(uni);
                sub = uni.doubleValue() * cardex.getCan().doubleValue();
                subTotal = subTotal.add(new BigDecimal(sub));
                cardex.setSub(new BigDecimal(sub));
            } else {
                cardex.setUni(new BigDecimal(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice()));
                Double sub3 = Double.valueOf(((PluRequest)orden.getPLUs().get(i)).getTodaysPrice()) * Double.valueOf(cardex.getCan().toString());
                subBD = new BigDecimal(sub3);
                subTotal = subTotal.add(subBD);
                cardex.setSub(new BigDecimal(sub3));
            }
            cardexTablet.setVod(".");
            cardex.setVod(".");
            cardex.setCanceladoGerente(".");
            cardex.setHoraCancelado(".");
            cardex.setPluId(((PluRequest)orden.getPLUs().get(i)).getId());
            cardex.setIva(new BigDecimal(0));
            cardex.setAbr(cuenta.getEmpleadoAbridorNum());
            cardex.setOrd(orden.getEmpOrd());
            cardex.setLoc(cuenta.getLocacion());
            cardex.setMca(".");
            cardex.setReo("1");
            cardex.setVodImp("0");
            cardex.setStatusAbierto("0");
            cardex.setTabIva("0");
            cardex.setFwd("0");
            cardex.setStaCort("0");
            cardex.setBono("0");
            cardex.setSubCalc(new BigDecimal(0));
            cardex.setIvaCalc(new BigDecimal(0));
            cardex.setDscCalc(new BigDecimal(0));
            if (existIepsColumn) {
                double ieps = (cardex.getSub().doubleValue() - cardex.getDscCalc().doubleValue()) / (1.0 + cardex.getIva().doubleValue() * this.getIepsValue()) * this.getIepsValue();
                iepsTotal += ieps;
                cardex.setIeps(BigDecimal.valueOf(ieps));
            }
            cardexTablet.setNumeroPlu(((PluRequest)orden.getPLUs().get(i)).getId());
            cardexTablet.setNot(((PluRequest)orden.getPLUs().get(i)).getNota());
            cardexTablet.setCveCuenta(cuentaTableta.getId());
            this.cardexRepository.save((Object)cardex);
            this.cardexTabRepository.save((Object)cardexTablet);
        }
        this.cuentaTabRepository.save((Object)cuentaTableta);
        Cuenta cuentaToUpdate = (Cuenta)this.cuentaService.findOne((Serializable)cuenta.getId());
        cuentaToUpdate.setSta("0");
        cuentaToUpdate.setSub(cuenta.getSub().add(subTotal));
        if (existIepsColumn) {
            double iepsCalc = iepsTotal;
            if (cuentaToUpdate.getIepsCalc() != null) {
                iepsCalc = cuentaToUpdate.getIepsCalc().doubleValue() + iepsTotal;
            }
            cuentaToUpdate.setIepsCalc(BigDecimal.valueOf(iepsCalc));
        }
        this.cuentaRepository.save((Object)cuenta);
        try {
            CuentaTabX cuentaTabX = new CuentaTabX();
            cuentaTabX.setPtrCuenta(cuenta.getId());
            cuentaTabX.setPtrTab(cuentaTableta.getId());
            cuentaTabX.setNumeroImpresiones(Integer.valueOf(0));
            cuentaTabX.setNumeroEnvios(Integer.valueOf(1));
            this.cuentaTabXRepository.save((Object)cuentaTabX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cuenta;
    }

    private double getIepsValue() {
        return 0.0;
    }

    public Cuenta ordenarCuenta(Cuenta cuenta, String plus, String pos, String empOrd, String cantidades, String precios, String cambios) {
        String[] plusIds = plus.split(",");
        int cont = 0;
        boolean isCombo = false;
        int comboItems = 0;
        boolean isCubeta = false;
        int cubetaCantidad = 1;
        String[] modCambios = cambios.split(",");
        String[] prices = precios.split(",");
        String[] cantidadesInd = cantidades.split(",");
        String comboName = "";
        BigDecimal subTotal = new BigDecimal(0.0);
        String pluIdToGiveAway = "";
        String plu2IdToGiveAway = "";
        String plu3IdToGiveAway = "";
        Boolean pluAdded = false;
        CuentaTab cuentaTableta = new CuentaTab();
        cuentaTableta.setId(Integer.valueOf(this.cuentaTabRepository.getFolio()));
        cuentaTableta.setCuenta(cuenta.getCuenta());
        cuentaTableta.setEmpleadoOrd(empOrd);
        cuentaTableta.setPersonas(cuenta.getNumPersonas().intValue());
        cuentaTableta.setNotas(1);
        cuentaTableta.setPos(pos);
        cuentaTableta.setTipo(cuenta.getTipo().intValue());
        cuentaTableta.setEstado("0");
        cuentaTableta.setTabCliente(cuenta.getCliente());
        cuentaTableta.setVta(Integer.valueOf(1));
        for (int i = 0; i < plusIds.length; ++i) {
            Double sub;
            PLUVista pluVista = (PLUVista)this.pluService.findOne((Serializable)((Object)plusIds[i]));
            double[] pluPrices = new double[]{pluVista.getPrecio1(), pluVista.getPrecio2(), pluVista.getPrecio3(), pluVista.getPrecio4(), pluVista.getPrecio5(), pluVista.getPrecio6(), pluVista.getPrecio7(), pluVista.getPrecio8(), pluVista.getPrecio9()};
            if (pluVista == null || pluVista.isCategory()) continue;
            Cardex cardex = new Cardex();
            CardexTab cardexTablet = new CardexTab();
            if (modCambios.length != 0 && pluVista.getId().equals("88990") || modCambios.length != 0 && pluVista.getMod().equals("1")) {
                cardex.setNombreCorto(modCambios[cont]);
                cardex.setNombreLargo(modCambios[cont]);
                cardexTablet.setNomL("   " + modCambios[cont]);
                cardex.setCan(new BigDecimal(0));
                cardexTablet.setCantidad(0);
                ++cont;
            } else if (isCombo) {
                if (this.parametrosGService.descriptionNeeded()) {
                    cardex.setNombreCorto(pluVista.getNombreCorto());
                    cardex.setNombreLargo(pluVista.getNombreLargo() + "\n  *" + comboName + "*");
                    cardexTablet.setNomL("   " + pluVista.getNombreLargo() + "\n  *" + comboName + "*");
                } else {
                    cardex.setNombreCorto(pluVista.getNombreCorto());
                    if (pluVista.getPrecio7() != 0.0) {
                        cardex.setNombreLargo(pluVista.getNombreCorto() + " *Dif*");
                        cardexTablet.setNomL("   " + pluVista.getNombreLargo() + " *Dif*");
                    } else {
                        cardex.setNombreLargo(pluVista.getNombreCorto());
                        cardexTablet.setNomL("   " + pluVista.getNombreLargo());
                    }
                }
                Double intCant = Double.valueOf(cantidadesInd[i]);
                cardex.setCan(new BigDecimal(intCant.intValue()));
                cardexTablet.setCantidad(intCant.intValue());
                if (comboItems == 1) {
                    isCombo = false;
                    comboName = "";
                }
                --comboItems;
            } else if (pluVista.getVec().charAt(21) == '1') {
                if (pluVista.getPrecio7() != 0.0) {
                    cardex.setNombreLargo(pluVista.getNombreCorto() + " *Dif*");
                } else {
                    cardex.setNombreLargo(pluVista.getNombreCorto());
                }
                cardex.setNombreCorto(pluVista.getNombreCorto());
                cardexTablet.setNomL(pluVista.getNombreCorto());
                Double intCant = Double.valueOf(cantidadesInd[i]);
                cardex.setCan(new BigDecimal(intCant.intValue()));
                cardexTablet.setCantidad(intCant.intValue());
                comboItems = pluVista.getNombreLargo().split(";").length;
                comboName = pluVista.getNombreCorto().toLowerCase();
                isCombo = true;
            } else if (pluVista.getVec().charAt(39) == '1') {
                isCubeta = true;
                String[] vec = pluVista.getNombreLargo().split(";");
                cubetaCantidad = Integer.parseInt(vec[1]);
                cardex.setNombreLargo(pluVista.getNombreCorto());
                if (pluVista.getVec().charAt(40) == '1') {
                    String[] vecs = pluVista.getNombreLargo().split(";");
                    pluIdToGiveAway = vecs[2];
                    if (vecs.length == 6) {
                        plu2IdToGiveAway = vecs[5];
                    } else if (vecs.length == 7) {
                        plu2IdToGiveAway = vecs[5];
                        plu3IdToGiveAway = vecs[6];
                    }
                }
                cardex.setNombreCorto(pluVista.getNombreCorto());
                cardexTablet.setNomL(pluVista.getNombreCorto());
                Double intCant = Double.valueOf(cantidadesInd[i]);
                cardex.setCan(new BigDecimal(intCant.intValue()));
                cardexTablet.setCantidad(intCant.intValue());
            } else if (this.isPLUPorPrecio(pluVista.getVec())) {
                cardex.setNombreCorto(pluVista.getNombreCorto());
                cardex.setNombreLargo(modCambios[cont]);
                cardexTablet.setNomL(modCambios[cont]);
                cardex.setCan(new BigDecimal(this.getCantPLUPorPrecio(modCambios[cont])));
                cardexTablet.setCantidad(0);
                ++cont;
            } else if (this.isOpenPLU(pluVista.getVec())) {
                cardex.setNombreCorto(modCambios[cont]);
                cardex.setNombreLargo(modCambios[cont]);
                cardexTablet.setNomL(modCambios[cont]);
                cardex.setCan(new BigDecimal(this.getCantPLUPorPrecio(cantidadesInd[i])));
                int canti = new BigDecimal(this.getCantPLUPorPrecio(cantidadesInd[i])).intValueExact();
                cardexTablet.setCantidad(canti);
            } else {
                if (pluVista.getId().equals(pluIdToGiveAway) || pluVista.getId().equals(plu2IdToGiveAway) || pluVista.getId().equals(plu3IdToGiveAway)) {
                    cardex.setNombreCorto(pluVista.getNombreCorto());
                    cardex.setNombreLargo(modCambios[cont]);
                    ++cont;
                } else if (isCubeta && cubetaCantidad > 0) {
                    if (pluVista.getVec().charAt(42) == '1') {
                        cardex.setNombreCorto(pluVista.getNombreCorto());
                        cardex.setNombreLargo("   " + modCambios[cont]);
                        ++cont;
                    } else {
                        cardex.setNombreCorto(pluVista.getNombreCorto());
                        cardex.setNombreLargo("   " + pluVista.getNombreLargo());
                    }
                    --cubetaCantidad;
                } else if (pluVista.getPrecio1() != Double.valueOf(prices[i]).doubleValue() && this.getPriceByEstrategy(pos) != -1) {
                    cardex.setNombreCorto("_" + pluVista.getNombreCorto());
                    cardex.setNombreLargo(pluVista.getNombreLargo());
                } else {
                    cardex.setNombreCorto(pluVista.getNombreCorto());
                    cardex.setNombreLargo(pluVista.getNombreLargo());
                }
                cardexTablet.setNomL(pluVista.getNombreLargo());
                BigDecimal cantidad = new BigDecimal(cantidadesInd[i]);
                cardex.setCan(cantidad);
                BigInteger canti = cantidad.toBigInteger();
                int cantDigit = canti.intValue();
                cardexTablet.setCantidad(cantDigit);
            }
            cardex.setCuentaPerteneciente(cuenta.getId());
            cardex.setHora(TimeDateUtils.getTime());
            cardex.setFecha(TimeDateUtils.getTodayDate());
            cardex.setPos(pos);
            cardex.setCuentaId(cuenta.getCuenta());
            cardex.setNot(Integer.valueOf(1));
            cardex.setStaEnv("s");
            if (this.getPriceByEstrategy(pos) != -1) {
                if (this.isOpenPLU(pluVista.getVec())) {
                    BigDecimal uni = new BigDecimal(modCambios[++cont]);
                    cardex.setUni(uni);
                    sub = uni.doubleValue() * cardex.getCan().doubleValue();
                    cardex.setSub(new BigDecimal(sub));
                    subTotal = subTotal.add(new BigDecimal(sub));
                    ++cont;
                } else {
                    cardex.setUni(new BigDecimal(pluPrices[this.getPriceByEstrategy(pos) - 1]));
                    cardex.setSub(new BigDecimal(pluPrices[this.getPriceByEstrategy(pos) - 1] * (double)Integer.parseInt(cantidadesInd[i])));
                    subTotal = subTotal.add(new BigDecimal(pluPrices[this.getPriceByEstrategy(pos) - 1] * (double)Integer.parseInt(cantidadesInd[i])));
                }
            } else if (this.isOpenPLU(pluVista.getVec())) {
                BigDecimal uni = new BigDecimal(modCambios[++cont]);
                cardex.setUni(uni);
                sub = uni.doubleValue() * cardex.getCan().doubleValue();
                subTotal = subTotal.add(new BigDecimal(sub));
                cardex.setSub(new BigDecimal(sub));
                ++cont;
            } else {
                cardex.setUni(new BigDecimal(prices[i]));
                Double sub2 = Double.valueOf(prices[i]) * Double.valueOf(cardex.getCan().toString());
                BigDecimal subBD = new BigDecimal(sub2);
                subTotal = subTotal.add(subBD);
                cardex.setSub(new BigDecimal(sub2));
            }
            cardexTablet.setVod(".");
            cardex.setVod(".");
            cardex.setCanceladoGerente(".");
            cardex.setHoraCancelado(".");
            cardex.setPluId(plusIds[i]);
            cardex.setIva(new BigDecimal(0));
            cardex.setAbr(cuenta.getEmpleadoAbridorNum());
            cardex.setOrd(empOrd);
            cardex.setLoc(cuenta.getLocacion());
            cardex.setMca(".");
            cardex.setReo("1");
            cardex.setVodImp("0");
            cardex.setStatusAbierto("0");
            cardex.setTabIva("0");
            cardex.setFwd("0");
            cardex.setStaCort("0");
            cardex.setBono("0");
            cardex.setSubCalc(new BigDecimal(0));
            cardex.setIvaCalc(new BigDecimal(0));
            cardex.setDscCalc(new BigDecimal(0));
            cardexTablet.setNumeroPlu(pluVista.getId());
            cardexTablet.setNot(1);
            cardexTablet.setCveCuenta(cuentaTableta.getId());
            this.cardexRepository.save((Object)cardex);
            this.cardexTabRepository.save((Object)cardexTablet);
        }
        Cuenta cuentaToUpdate = (Cuenta)this.cuentaService.findOne((Serializable)cuenta.getId());
        cuentaToUpdate.setEnv(Integer.valueOf(cuenta.getEnv() + 1));
        cuentaToUpdate.setSub(cuenta.getSub().add(subTotal));
        this.cuentaTabRepository.save((Object)cuentaTableta);
        this.cuentaRepository.save((Object)cuenta);
        try {
            CuentaTabX cuentaTabX = new CuentaTabX();
            cuentaTabX.setPtrCuenta(cuenta.getId());
            cuentaTabX.setPtrTab(cuentaTableta.getId());
            cuentaTabX.setNumeroImpresiones(Integer.valueOf(0));
            this.cuentaTabXRepository.save((Object)cuentaTabX);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cuenta;
    }

    public Double getCantPLUPorPrecio(String plu) {
        String cantidad = plu.split(" ")[0];
        Double cantidadNumerica = Double.valueOf(cantidad);
        return cantidadNumerica;
    }

    public boolean isPLUPorPrecio(String vec) {
        return vec.charAt(9) == '1';
    }

    public boolean isOpenPLU(String vec) {
        return vec.charAt(23) == '1';
    }

    public double addIva(String tablaIva, double price) {
        double ivaToAdd = 0.0;
        double priceIvaAdded = 0.0;
        List ivas = this.tabIvaRepository.findAll();
        for (TabIvaVista iva : ivas) {
            if (!iva.getId().equals(tablaIva)) continue;
            ivaToAdd = iva.getPorcentaje();
            priceIvaAdded = price * ivaToAdd / 100.0;
        }
        return priceIvaAdded;
    }

    private int getWeekDay() {
        String diaActual = LocalDate.now().getDayOfWeek().name();
        int diaActualNumero = 0;
        switch (diaActual) {
            case "MONDAY": {
                diaActualNumero = 1;
                break;
            }
            case "TUESDAY": {
                diaActualNumero = 2;
                break;
            }
            case "WEDNESDAY": {
                diaActualNumero = 3;
                break;
            }
            case "THURSDAY": {
                diaActualNumero = 4;
                break;
            }
            case "FRIDAY": {
                diaActualNumero = 5;
                break;
            }
            case "SATURDAY": {
                diaActualNumero = 6;
                break;
            }
            case "SUNDAY": {
                diaActualNumero = 7;
            }
        }
        return diaActualNumero;
    }

    private int filterActualHour(String hr) {
        String[] hour = hr.split(":");
        return Integer.parseInt(hour[0]);
    }

    private int filterActualMinutes(String hr) {
        String[] hour = hr.split(":");
        return Integer.parseInt(hour[1]);
    }

    private int actualHour() {
        LocalTime time = LocalTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String completeTime = time.format(formatter);
        String[] hour = completeTime.split(":");
        return Integer.parseInt(hour[0]);
    }

    private int actualMinutes() {
        LocalTime time = LocalTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String completeTime = time.format(formatter);
        String[] hour = completeTime.split(":");
        return Integer.parseInt(hour[1]);
    }

    private boolean isInTimeRange(String hr1, String hr2) {
        boolean flag = false;
        int initHour = this.filterActualHour(hr1);
        int initMin = this.filterActualMinutes(hr1);
        int finalHour = this.filterActualHour(hr2);
        int finalMin = this.filterActualMinutes(hr2);
        if (this.actualHour() >= initHour && this.actualMinutes() >= initMin && this.actualHour() <= finalHour && this.actualMinutes() <= finalMin) {
            flag = true;
        }
        return flag;
    }

    public int getPriceByEstrategy(String pos) {
        List peps = this.estrategiaPreciosRepository.findAllByPos(pos);
        int tablaPrecios = -1;
        for (EstrategiaPrecios pep : peps) {
            if (!this.isInTimeRange(pep.getHoraInicio(), pep.getHoraFinal()) || pep.getDiaSemana() != this.getWeekDay()) continue;
            tablaPrecios = pep.getTablaPrecios();
        }
        return tablaPrecios;
    }

    public void cancelarPLUFuncion(Cardex cardex, Integer cuentaID, String emplCan, String motivoCan) {
        CuentaTab cuentaTableta = new CuentaTab();
        cuentaTableta.setId(Integer.valueOf(this.cuentaTabRepository.getFolio()));
        cuentaTableta.setCuenta(cuentaID.toString());
        cuentaTableta.setEmpleadoOrd(emplCan);
        cuentaTableta.setPersonas(1);
        cuentaTableta.setNotas(cardex.getNot().intValue());
        cuentaTableta.setPos(cardex.getPos());
        cuentaTableta.setTipo(1);
        cuentaTableta.setEstado("0");
        cuentaTableta.setTabCliente("");
        cuentaTableta.setVta(Integer.valueOf(1));
        CardexTab cardexTablet = new CardexTab();
        cardexTablet.setNomL(cardex.getPlu().getNombreLargo());
        cardexTablet.setCantidad(cardex.getCan().intValue());
        cardexTablet.setVod("V");
        cardexTablet.setNumeroPlu(cardex.getPlu().getId());
        cardexTablet.setNot(1);
        cardexTablet.setCveCuenta(cuentaTableta.getId());
        cardex.setCanceladoGerente(emplCan);
        cardex.setHoraCancelado(TimeDateUtils.getTime());
        cardex.setMca(motivoCan);
        cardex.setVod("V");
        cardex.setVodImp("1");
        this.cardexRepository.save((Object)cardex);
        this.cardexTabRepository.save((Object)cardexTablet);
        this.cuentaTabRepository.save((Object)cuentaTableta);
    }

    public List<Cardex> cancelarPLus(Integer cuentaId, CancelacionesRequest cancelaciones) {
        Cuenta cuentaToUpdate = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        BigDecimal newSubTotal = cuentaToUpdate.getSub();
        ArrayList<Cardex> cardexesARegresar = new ArrayList<Cardex>();
        List cardexes = this.getCardexesByCuenta(cuentaId);
        for (Cardex cardexAux : cardexes) {
            for (CancelacionRequest cancelacion : cancelaciones.getCancelaciones()) {
                if (cardexAux.getId().intValue() != cancelacion.getCardexID()) continue;
                this.cancelarPLUFuncion(cardexAux, cancelacion.getCuentaID(), cancelacion.getEmplCan(), cancelacion.getMotivoCan());
                cardexesARegresar.add(cardexAux);
                newSubTotal = newSubTotal.subtract(cardexAux.getSub());
            }
        }
        cuentaToUpdate.setSub(newSubTotal);
        this.cuentaService.save((Object)cuentaToUpdate);
        return cardexesARegresar;
    }

    public ResponseEntity<Cardex> cancelarPLU(Integer cuentaId, int idCardex, String emplCan, String motivoCan) {
        List cardexes = this.getCardexesByCuenta(cuentaId);
        Cardex cardex = null;
        for (Cardex cardexAux : cardexes) {
            if (cardexAux.getId() != idCardex) continue;
            cardex = cardexAux;
        }
        if (cardex != null) {
            CuentaTab cuentaTableta = new CuentaTab();
            cuentaTableta.setId(Integer.valueOf(this.cuentaTabRepository.getFolio()));
            cuentaTableta.setCuenta(cuentaId.toString());
            cuentaTableta.setEmpleadoOrd(emplCan);
            cuentaTableta.setPersonas(1);
            cuentaTableta.setNotas(cardex.getNot().intValue());
            cuentaTableta.setPos(cardex.getPos());
            cuentaTableta.setTipo(1);
            cuentaTableta.setEstado("0");
            cuentaTableta.setTabCliente("");
            cuentaTableta.setVta(Integer.valueOf(1));
            CardexTab cardexTablet = new CardexTab();
            cardexTablet.setNomL(cardex.getNombreLargo());
            cardexTablet.setCantidad(cardex.getCan().intValue());
            cardexTablet.setVod("V");
            cardexTablet.setNumeroPlu(cardex.getPlu().getId());
            cardexTablet.setNot(1);
            cardexTablet.setCveCuenta(cuentaTableta.getId());
            cardex.setCanceladoGerente(emplCan);
            cardex.setHoraCancelado(TimeDateUtils.getTime());
            cardex.setMca(motivoCan);
            cardex.setVod("V");
            cardex.setVodImp("1");
            this.cardexRepository.save((Object)cardex);
            this.cardexTabRepository.save((Object)cardexTablet);
            this.cuentaTabRepository.save((Object)cuentaTableta);
            return new ResponseEntity((Object)cardex, HttpStatus.OK);
        }
        throw new EntityNotFoundException("El cardex a modificar no existe");
    }
}

