/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.PLUVista;
import com.sierra.pdv.domain.request.PlusByIDRequest;
import com.sierra.pdv.repositories.PLURepository;
import com.sierra.pdv.service.CardexService;
import com.sierra.pdv.service.PLUService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/plu"})
public class PLURest {
    @Autowired
    private PLURepository pluRepository;
    @Autowired
    private PLUService pluService;
    @Autowired
    private CardexService cardexService;

    @GetMapping
    public List<PLUVista> getAllPLUS() {
        return this.pluService.getAllPLUS();
    }

    @GetMapping(value={"/categorias"})
    public List<PLUVista> getAllCategories() {
        return this.pluService.getAllCategories();
    }

    @GetMapping(value={"/sub-categorias"})
    public List<PLUVista> getAllSubCategories() {
        return this.pluService.getAllSubCategories();
    }

    @GetMapping(value={"/{pos}"})
    public int getPriceByEstrategy(@PathVariable String pos) {
        return this.cardexService.getPriceByEstrategy(pos);
    }

    @GetMapping(value={"/categorias/{categoria}/{importe}"})
    public List<PLUVista> getPlusCategorias(@PathVariable(value="categoria") String categoria, @PathVariable(value="importe") String importe) {
        return this.pluService.getPlusSubCategories(categoria, importe);
    }

    @PostMapping(value={"/byID"})
    public List<PLUVista> getPLUSByID(@RequestBody PlusByIDRequest plus) {
        return this.pluService.getPlusByID((List)plus.getPLUs());
    }
}

