/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.Cardex;
import com.sierra.pdv.domain.request.CancelacionesRequest;
import com.sierra.pdv.service.CardexService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cardex"})
public class CardexRest {
    @Autowired
    private CardexService cardexService;

    @GetMapping(value={"/{cuentaId}"})
    public List<Cardex> getCardexesByAccount(@PathVariable(value="cuentaId") int cuentaId) {
        return this.cardexService.getCardexesByCuenta(Integer.valueOf(cuentaId));
    }

    @PutMapping(value={"/{idCuenta}"})
    public ResponseEntity<Cardex> cancelarPLU(@PathVariable(value="idCuenta") Integer cuentaId, @RequestParam(value="idCardex") int idCardex, @RequestParam(value="emp_can") String emplCan, @RequestParam(value="mot_can") String motivoCan) {
        return this.cardexService.cancelarPLU(cuentaId, idCardex, emplCan, motivoCan);
    }

    @PutMapping(value={"/cancelaciones/{idCuenta}"})
    public List<Cardex> cancelarPLU(@PathVariable(value="idCuenta") Integer cuentaId, @RequestBody CancelacionesRequest cancelaciones) {
        return this.cardexService.cancelarPLus(cuentaId, cancelaciones);
    }
}

