/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.domain.entity.vistas;

import com.sierra.pdv.domain.Color;
import com.sierra.pdv.domain.entity.vistas.PLUVista;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import jdk.nashorn.internal.ir.annotations.Immutable;

@Entity
@Table(name="vwTbc")
@Immutable
public class ItemTableroVista {
    @Id
    @Column(name="aCve")
    private String id;
    @Column(name="aTab")
    private String tableroId;
    @Column(name="aBtn")
    private String boton;
    @Column(name="aPlu")
    private String pluId;
    @Column(name="aTxt")
    private String nombre;
    @Column(name="aImg")
    private String img;
    @Column(name="aNomL")
    private String nombreLargo;
    @Column(name="aNomC")
    private String nombreCorto;
    @Column(name="aNegBla")
    private int letraBlanca;
    @Column(name="aNorNeg")
    private int letraNegrita;
    @Column(name="aTamLet")
    private int tamanioLetra;
    @Transient
    private PLUVista pluVista;
    @Transient
    private PLUVista categoriaPLU;

    @PostLoad
    protected void repair() {
        if (this.nombre != null) {
            this.nombre = this.nombre.trim();
        }
        if (this.img != null) {
            this.img = this.img.trim();
        }
        if (this.nombreLargo != null) {
            this.nombreLargo = this.nombreLargo.trim();
        }
        if (this.nombreCorto != null) {
            this.nombreCorto = this.nombreCorto.trim();
        }
    }

    public boolean isImagen() {
        if (this.img != null) {
            return Color.getColorPorNombre((String)this.img) == Color.IMAGEN;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getTableroId() {
        return this.tableroId;
    }

    public String getBoton() {
        return this.boton;
    }

    public String getPluId() {
        return this.pluId;
    }

    public String getNombre() {
        return this.nombre;
    }

    public String getImg() {
        return this.img;
    }

    public String getNombreLargo() {
        return this.nombreLargo;
    }

    public String getNombreCorto() {
        return this.nombreCorto;
    }

    public int getLetraBlanca() {
        return this.letraBlanca;
    }

    public int getLetraNegrita() {
        return this.letraNegrita;
    }

    public int getTamanioLetra() {
        return this.tamanioLetra;
    }

    public PLUVista getPluVista() {
        return this.pluVista;
    }

    public PLUVista getCategoriaPLU() {
        return this.categoriaPLU;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTableroId(String tableroId) {
        this.tableroId = tableroId;
    }

    public void setBoton(String boton) {
        this.boton = boton;
    }

    public void setPluId(String pluId) {
        this.pluId = pluId;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public void setNombreLargo(String nombreLargo) {
        this.nombreLargo = nombreLargo;
    }

    public void setNombreCorto(String nombreCorto) {
        this.nombreCorto = nombreCorto;
    }

    public void setLetraBlanca(int letraBlanca) {
        this.letraBlanca = letraBlanca;
    }

    public void setLetraNegrita(int letraNegrita) {
        this.letraNegrita = letraNegrita;
    }

    public void setTamanioLetra(int tamanioLetra) {
        this.tamanioLetra = tamanioLetra;
    }

    public void setPluVista(PLUVista pluVista) {
        this.pluVista = pluVista;
    }

    public void setCategoriaPLU(PLUVista categoriaPLU) {
        this.categoriaPLU = categoriaPLU;
    }
}

