/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.exception;

import com.sierra.pdv.exception.EntityException;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.exception.ErrorDetails;
import com.sierra.pdv.exception.UserExistException;
import java.util.Date;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@RestController
public class AppResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={Exception.class})
    public final ResponseEntity<ErrorDetails> handleAllExceptions(Exception ex, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(new Date(), ex.getMessage(), request.getDescription(true), ex.getLocalizedMessage());
        return new ResponseEntity((Object)errorDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public final ResponseEntity<ErrorDetails> handleUserNotFoundException(EntityNotFoundException ex, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(new Date(), ex.getMessage(), request.getDescription(true), ex.getErrorMessage());
        return new ResponseEntity((Object)errorDetails, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={UserExistException.class})
    public final ResponseEntity<ErrorDetails> handleUserExistException(UserExistException ex, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(new Date(), ex.getMessage(), request.getDescription(true), ex.getErrorMessage());
        return new ResponseEntity((Object)errorDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={EntityException.class})
    public final ResponseEntity<ErrorDetails> handleEntityException(EntityException ex, WebRequest request) {
        ErrorDetails errorDetails = new ErrorDetails(new Date(), ex.getMessage(), request.getDescription(true), ex.getErrorMessage());
        return new ResponseEntity((Object)errorDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

