/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.Reservacion;
import com.sierra.pdv.service.ReservacionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reservacion"})
public class ReservacionRest {
    @Autowired
    private ReservacionService reservacionService;

    @GetMapping
    public List<Reservacion> getAllReservaciones() {
        return this.reservacionService.getAllReservaciones();
    }

    @GetMapping(value={"/{reservacionId}"})
    public ResponseEntity<Reservacion> getMotivoCancelacionByID(@PathVariable(value="reservacionId") String ID) {
        Reservacion reservacion = this.reservacionService.getReservacionByID(ID);
        if (reservacion != null) {
            return new ResponseEntity((Object)reservacion, HttpStatus.OK);
        }
        return new ResponseEntity(null, HttpStatus.NOT_FOUND);
    }
}

