/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.domain.base;

import com.sierra.pdv.domain.base.Audit;
import com.sierra.pdv.domain.base.Auditable;
import com.sierra.pdv.domain.base.LoggedUser;
import java.util.Date;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

public class AuditListener {
    @PrePersist
    public void setCreatedOn(Auditable auditable) {
        Audit audit = auditable.getAudit();
        if (audit == null) {
            audit = new Audit();
            auditable.setAudit(audit);
        }
        audit.setCreatedOn(new Date());
        audit.setCreatedBy(LoggedUser.get());
    }

    @PreUpdate
    public void setUpdatedOn(Auditable auditable) {
        Audit audit = auditable.getAudit();
        audit.setUpdatedOn(new Date());
        audit.setUpdatedBy(LoggedUser.get());
    }
}

