/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.service;

import com.sierra.pdv.domain.entity.vistas.PLUVista;
import com.sierra.pdv.repositories.PLURepository;
import com.sierra.pdv.service.base.ServiceBase;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class PLUService
extends ServiceBase<PLUVista, String> {
    @Autowired
    private PLURepository repository;

    public PLUService(CrudRepository<PLUVista, String> repo) {
        super(repo);
    }

    public List<PLUVista> getAllCategories() {
        List pluses = this.repository.findAll();
        ArrayList<PLUVista> categories = new ArrayList<PLUVista>();
        for (PLUVista pluVista : pluses) {
            if (pluVista.getId().trim().length() != 1) continue;
            categories.add(pluVista);
        }
        return categories;
    }

    public List<PLUVista> getAllSubCategories() {
        List pluses = this.repository.findAll();
        ArrayList<PLUVista> categories = new ArrayList<PLUVista>();
        for (PLUVista pluVista : pluses) {
            if (pluVista.getId().trim().length() <= 1 || pluVista.getId().trim().length() > 3) continue;
            categories.add(pluVista);
        }
        return categories;
    }

    public List<PLUVista> getAllPLUS() {
        return this.repository.findAll();
    }

    public List<PLUVista> getPlusSubCategories(String categoria, String importe) {
        List pluses = this.repository.findAll();
        ArrayList<PLUVista> categories = new ArrayList<PLUVista>();
        for (PLUVista pluVista : pluses) {
            if (!pluVista.getId().startsWith(categoria) || !pluVista.getMod().equals("0") || pluVista.getId().equals(categoria) || pluVista.getNombreLargo().contains(";") || pluVista.getNombreLargo().chars().allMatch(Character::isDigit)) continue;
            if (importe != "0") {
                if (!(pluVista.getPrecio1() >= Double.parseDouble(importe))) continue;
                categories.add(pluVista);
                continue;
            }
            categories.add(pluVista);
        }
        return categories;
    }
}

