/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.service;

import com.sierra.pdv.domain.entity.Cuenta;
import com.sierra.pdv.domain.entity.CuentaTab;
import com.sierra.pdv.repositories.CuentaTabRepository;
import com.sierra.pdv.service.CardexTabService;
import com.sierra.pdv.service.base.ServiceBase;
import javax.persistence.EntityManager;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceContext;
import javax.persistence.StoredProcedureQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class CuentaTabService
extends ServiceBase<CuentaTab, Integer> {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private CuentaTabRepository cuentaRepository;
    @Autowired
    private CardexTabService cardexService;

    public CuentaTabService(CrudRepository<CuentaTab, Integer> repo) {
        super(repo);
    }

    public CuentaTab saveCuenta(String numCuenta, String empleadoNum, String pos, String nombreCuenta, int numPersonas, int numNotas) {
        CuentaTab cuenta = new CuentaTab();
        cuenta.setCuenta(Cuenta.transformNumCuenta((String)numCuenta));
        cuenta.setEmpleadoOrd(empleadoNum);
        cuenta.setPersonas(numPersonas);
        cuenta.setNotas(1);
        cuenta.setEstado("0");
        return (CuentaTab)this.cuentaRepository.save((Object)cuenta);
    }

    public int getCuentaTabFolio() {
        StoredProcedureQuery query = this.em.createStoredProcedureQuery("sp_FolioCmd");
        query.registerStoredProcedureParameter("RC", Integer.class, ParameterMode.OUT);
        Boolean result = query.execute();
        int folio = (Integer)query.getSingleResult();
        return folio;
    }
}

