/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.AutomaticAccountResponse;
import com.sierra.pdv.domain.entity.Cuenta;
import com.sierra.pdv.domain.entity.ImpTab;
import com.sierra.pdv.exception.CuentaNoAbiertaException;
import com.sierra.pdv.exception.EntityException;
import com.sierra.pdv.exception.EntityExistsException;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.repositories.CuentaRepository;
import com.sierra.pdv.repositories.ImpTabRepository;
import com.sierra.pdv.service.CardexService;
import com.sierra.pdv.service.CuentaService;
import com.sierra.pdv.service.EmpleadoService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cuenta"})
public class CuentaRest {
    @Autowired
    private CuentaService cuentaService;
    @Autowired
    private CuentaRepository cuentaRepository;
    @Autowired
    private ImpTabRepository impTabRepository;
    @Autowired
    CardexService cardexService;
    @Autowired
    private EmpleadoService empleadoService;

    @GetMapping(value={"/{meseroId}"})
    public List<Cuenta> getCuentasByMesero(@PathVariable(value="meseroId") String meseroId) {
        return this.cuentaService.getCuentasByMesero(meseroId);
    }

    @GetMapping
    public List<Cuenta> getAllAccounts() {
        return this.cuentaService.getAllCuentas();
    }

    @PostMapping(value={"/imprimirCuenta/{num_cuenta}"})
    public ResponseEntity<ImpTab> imprimirCuenta(@PathVariable(value="num_cuenta") String numCuenta, @RequestParam(name="pos") String pos, @RequestParam(value="emp_imp") String empImp) {
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)Integer.valueOf(Integer.parseInt(numCuenta)));
        if (cuenta != null) {
            ImpTab preImpresion = (ImpTab)this.impTabRepository.findOne((Serializable)Integer.valueOf(Integer.parseInt(numCuenta)));
            if (this.impTabRepository.findOne((Serializable)Integer.valueOf(Integer.parseInt(numCuenta))) != null) {
                preImpresion.setPos(pos);
                preImpresion.setEmpleadoImpr(empImp);
                preImpresion.setStatus("0");
                this.impTabRepository.save((Object)preImpresion);
                return new ResponseEntity((Object)preImpresion, HttpStatus.OK);
            }
            ImpTab impresion = this.cuentaService.imprimirCuenta(cuenta, pos, empImp);
            if (impresion != null) {
                return new ResponseEntity((Object)impresion, HttpStatus.OK);
            }
            throw new EntityException("Ha ocurrido un error al imprimir esta cuenta. Contacte con soporte t\u00e9cnico.");
        }
        throw new EntityExistsException("Ha ocurrido un error al imprimir esta cuenta. Contacte con soporte t\u00e9cnico.");
    }

    @PostMapping(value={"/abrir"})
    public ResponseEntity<Cuenta> abrirCuenta(@RequestParam(value="num_cuenta") String numCuenta, @RequestParam(value="num_empleado") String empleadoNum, @RequestParam(name="num_personas", required=false) Integer numeroPersonas, @RequestParam(name="pos", required=false) String pos, @RequestParam(name="num_notas", required=false) Integer numeroNotas, @RequestParam(name="nombre_cuenta", required=false) String nombreCuenta, @RequestParam(name="tipo_cuenta", required=false) Integer tipoCuenta) {
        Cuenta cuenta = this.cuentaService.getCuenta(numCuenta);
        if (cuenta == null) {
            Cuenta newCuenta = this.cuentaService.saveCuenta(numCuenta, empleadoNum, pos, nombreCuenta, numeroPersonas.intValue(), numeroNotas.intValue(), tipoCuenta.intValue());
            if (newCuenta != null) {
                return new ResponseEntity((Object)newCuenta, HttpStatus.OK);
            }
            throw new EntityException("Ha ocurrido un error al abrir esta cuenta. Contacte con soporte t\u00e9cnico.");
        }
        throw new EntityExistsException("La cuenta que desea abrir ya se encuentra abierta");
    }

    @GetMapping(value={"getCountAllCuentasEmpleado/{meseroId}"})
    public int checkForEmpLimit(@PathVariable(value="meseroId") String meseroId) {
        return this.cuentaService.getAllCuentasByMesero(meseroId).size();
    }

    @PostMapping(value={"/{cuenta_id}/ordenar"})
    public Cuenta ordenarCuenta(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="plus") String plus, @RequestParam(name="pos", required=false) String pos, @RequestParam(value="emp_ord") String empOrd, @RequestParam(value="cantidades") String cantidades, @RequestParam(value="precios") String precios, @RequestParam(value="cambios") String cambios) {
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta != null) {
            String status = cuenta.getSta();
            String cobrada = cuenta.getEstadoAbierto();
            if (status != null && cobrada.equalsIgnoreCase("0")) {
                return this.cardexService.ordenarCuenta(cuenta, plus, pos, empOrd, cantidades, precios, cambios);
            }
            throw new CuentaNoAbiertaException("La cuenta en la que intenta ordenar est\u00e1 abierta o ya fue cobrada");
        }
        throw new EntityNotFoundException("La cuenta en la que intenta ordenar no existe.");
    }

    @PostMapping(value={"/{cuenta_id}/cambiarStatus"})
    public Cuenta changeStatus(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="status") String status) {
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        cuenta.setSta(status);
        this.cuentaService.save((Object)cuenta);
        return cuenta;
    }

    @PutMapping(value={"/{cuenta_id}"})
    public Cuenta asignarNombre(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="name") String nombre) {
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta == null) {
            throw new EntityNotFoundException("La cuenta en la que intenta operar no existe.");
        }
        cuenta.setNombreCuenta(nombre);
        this.cuentaService.save((Object)cuenta);
        return cuenta;
    }

    @GetMapping(value={"/cuentaAutomatica"})
    public AutomaticAccountResponse getAutomaticAccountFolio() {
        int folio = this.cuentaService.getAutoFolio();
        AutomaticAccountResponse response = new AutomaticAccountResponse(Boolean.valueOf(true), folio);
        return response;
    }

    @GetMapping(value={"/checkPrintTimes/{cuenta_id}"})
    public Cuenta checkForPrintTimes(@PathVariable(value="cuenta_id") Integer cuentaId) {
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta == null) {
            throw new EntityNotFoundException("La cuenta en la que intenta operar no existe.");
        }
        return cuenta;
    }

    @GetMapping(value={"/allOpenAccounts"})
    public List<Cuenta> getAllOpenAccounts() {
        return this.cuentaRepository.findAllByEstadoAbiertoAndSta("0", "0");
    }
}

