/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.user;

import com.sierra.base.config.security.CurrentUser;
import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.domain.request.base.UserRequest;
import com.sierra.base.domain.response.SierraApi.ClientsResponse;
import com.sierra.base.domain.response.base.ApiResponse;
import com.sierra.base.domain.response.base.ApiResponseData;
import com.sierra.base.endpoint.SierraApi;
import com.sierra.base.exception.ResourceNotFoundException;
import com.sierra.base.repository.UserRepository;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController(value="Userv1.0.0")
@RequestMapping(value={"/api"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class UserRest {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private SierraApi sierraApi;

    @GetMapping(value={"/user/{userId:}"})
    public ResponseEntity<?> getUsuario(@PathVariable(value="userId") Long userId) {
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ResourceNotFoundException("El usuario", "identificador", (Object)userId));
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)user));
    }

    @GetMapping(value={"/user/session"})
    public ResponseEntity<?> getCurrentUser(@CurrentUser UserPrincipal userPrincipal) {
        User user = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("El usuario", "identificador", (Object)userPrincipal.getId()));
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)user));
    }

    @PutMapping(value={"/user/{id}/enabled"})
    public ResponseEntity<?> updateUser(@PathVariable(value="id") Long id, @RequestParam(value="enabled") Boolean enabled) {
        User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("El usuario", "identificador", (Object)id));
        user.setEnabled(enabled.booleanValue());
        try {
            this.userRepository.save((Object)user);
        }
        catch (Exception e) {
            return ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al realizar la acci\u00f3n, intente de nuevo m\u00e1s tarde"));
        }
        if (enabled.booleanValue()) {
            return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha habilitado exitosamente el usuario " + user.getEmail()));
        }
        return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha deshabilitado exitosamente el usuario " + user.getEmail()));
    }

    @PostMapping(value={"/user/admin"})
    public ResponseEntity<?> createUserAdmin(@Valid @RequestBody UserRequest newAdminRequest) {
        User newUser = new User(newAdminRequest.getName(), newAdminRequest.getLastname(), newAdminRequest.getEmail());
        newUser.setPhone(newAdminRequest.getPhone());
        newUser.setPassword(newAdminRequest.getPassword());
        newUser.setPassword(this.passwordEncoder.encode((CharSequence)newUser.getPassword()));
        try {
            this.userRepository.save((Object)newUser);
        }
        catch (Exception e) {
            return ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al realizar la acci\u00f3n, intente de nuevo m\u00e1s tarde"));
        }
        return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha registrado exitosamente el administrador " + newAdminRequest.getEmail()));
    }

    @GetMapping(value={"/getPhone/{email}"})
    public ResponseEntity<?> resetPassword(@PathVariable(value="email") String email) {
        User user = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new ResourceNotFoundException("EL usuario", "email", (Object)email));
        return ResponseEntity.ok().body((Object)new ApiResponse(true, user.getPhone()));
    }

    @GetMapping(value={"/user/clients"})
    public ResponseEntity<?> getUsers(@RequestParam(value="query") String query, @CurrentUser UserPrincipal userPrincipal) {
        Object clients = null;
        User user = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("El usuario", "identificador", (Object)userPrincipal.getId()));
        if (clients == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)"No se encontro ningun cliente"));
        }
        ClientsResponse response = new ClientsResponse(clients.getCount(), clients.getClients());
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response));
    }
}

