/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.giftcard;

import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.Environment;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionRequest;
import com.braintreegateway.ValidationError;
import com.sierra.base.config.security.CurrentUser;
import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.domain.entity.base.RecargaRequest;
import com.sierra.base.domain.entity.giftcard.Giftcard;
import com.sierra.base.domain.entity.giftcard.UsuarioGiftcard;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.domain.request.AssignGiftcardRequest;
import com.sierra.base.domain.request.CambioPinRequest;
import com.sierra.base.domain.request.CargoRequest;
import com.sierra.base.domain.request.PinRequest;
import com.sierra.base.domain.request.RecargaGiftcardRequest;
import com.sierra.base.domain.request.RegistroGiftcardRequest;
import com.sierra.base.domain.request.RegistroRequest;
import com.sierra.base.domain.request.base.SierraTokenRequest;
import com.sierra.base.domain.response.SierraApi.GiftcardResponse;
import com.sierra.base.domain.response.SierraApi.SierraTokenResponse;
import com.sierra.base.domain.response.base.ApiResponse;
import com.sierra.base.domain.response.base.ApiResponseData;
import com.sierra.base.endpoint.SierraApi;
import com.sierra.base.exception.ResourceNotFoundException;
import com.sierra.base.repository.GiftcardTransactionRepository;
import com.sierra.base.repository.UserRepository;
import com.sierra.base.repository.UsuarioGiftcardRepository;
import com.sierra.base.service.base.EmailService;
import com.sierra.base.service.giftcard.UsuarioGiftcardService;
import com.sierra.base.util.NIP;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@CrossOrigin(origins={"*"})
@RestController(value="Giftcardv1.0.0")
@RequestMapping(value={"/api"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class GiftcardRest {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UsuarioGiftcardRepository usuarioGiftcardRepository;
    @Autowired
    private UsuarioGiftcardService usuarioGiftcardService;
    @Autowired
    private SierraApi sierraApi;
    @Autowired
    private GiftcardTransactionRepository giftcardTransactionRepository;
    @Autowired
    private EmailService emailService;
    private static BraintreeGateway gateway = new BraintreeGateway(Environment.SANDBOX, "nrvdrxpx7kcrkrcy", "2kgc7ycx3hw96n3m", "31d801397bbbed0f4d92b5b49398e168");

    @GetMapping(value={"/braintreetoken"})
    public ResponseEntity<?> getBTToken(@CurrentUser UserPrincipal userPrincipal) {
        String clientToken = gateway.clientToken().generate();
        if (clientToken == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)clientToken));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)clientToken));
    }

    @PostMapping(value={"/payment"})
    public String postForm(@CurrentUser UserPrincipal userPrincipal, @RequestParam(value="amount") String amount, @RequestParam(value="payment_method_nonce") String nonce, @RequestParam(value="name") String name, @RequestParam(value="message") String message, @RequestParam(value="to") String to, @RequestParam(value="date") String date, @RequestParam(value="type") int type, Model model, RedirectAttributes redirectAttributes) {
        BigDecimal decimalAmount;
        try {
            decimalAmount = new BigDecimal(amount);
        }
        catch (NumberFormatException e) {
            redirectAttributes.addFlashAttribute("errorDetails", (Object)"Error: 81503: Amount is an invalid format.");
            return "redirect:checkouts";
        }
        TransactionRequest request = new TransactionRequest().amount(decimalAmount).paymentMethodNonce(nonce).options().submitForSettlement(Boolean.valueOf(true)).done();
        Result result = gateway.transaction().sale(request);
        if (result.isSuccess()) {
            Transaction transaction = (Transaction)result.getTarget();
            this.emailService.reciboPaypal(userPrincipal.getEmail(), name, transaction.getId(), "Compra de certificado", amount, date);
            this.giftcardRegister(userPrincipal, new RegistroRequest(to, message, name, amount, 1, transaction.getId(), transaction.getId(), date, ""));
            return "redirect:checkouts/" + transaction.getId();
        }
        if (result.getTransaction() != null) {
            Transaction transaction = result.getTransaction();
            return "redirect:checkouts/" + transaction.getId();
        }
        StringBuilder errorString = new StringBuilder();
        for (ValidationError error : result.getErrors().getAllDeepValidationErrors()) {
            errorString.append("Error: ").append(error.getCode()).append(": ").append(error.getMessage()).append("\n");
        }
        redirectAttributes.addFlashAttribute("errorDetails", (Object)errorString.toString());
        return "redirect:checkouts";
    }

    @GetMapping(value={"/giftcards"})
    public ResponseEntity<?> getGiftcards(@CurrentUser UserPrincipal userPrincipal) {
        List list = null;
        try {
            if (this.usuarioGiftcardRepository.findAllByOwner_Id(userPrincipal.getId()).size() != 0) {
                list = this.usuarioGiftcardService.getUsersGiftcard(userPrincipal.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (list == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, list));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, list));
    }

    @PutMapping(value={"/giftcards/recarga"})
    public ResponseEntity<?> recargar(@CurrentUser UserPrincipal userPrincipal, @Valid @RequestBody RecargaRequest request) {
        User user = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("User", "id", (Object)userPrincipal.getId()));
        SierraTokenResponse tokenResponse = null;
        GiftcardResponse response = null;
        Object list = null;
        try {
            tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
            response = this.sierraApi.recarga("Bearer " + tokenResponse.getAccess_token(), request.getCardNumber(), new RecargaGiftcardRequest(request.getAmount(), request.getStore(), request.getPaymentId()));
            this.usuarioGiftcardService.saveRecibo(userPrincipal.getId().toString(), request.getPaymentId(), String.valueOf(((Giftcard)response.getGiftcards().get(0)).getId()), Double.valueOf(request.getAmount()), request.getCardNumber(), 1);
            this.emailService.reciboPaypal(user.getEmail(), user.getName(), request.getPaymentId(), "Recarga a certificado", request.getAmount().toString(), request.getCreatedTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, list));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response.getGiftcards()));
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/giftcard"})
    public ResponseEntity<?> assignGiftcard(@CurrentUser UserPrincipal userPrincipal, @RequestPart(value="request") @Valid AssignGiftcardRequest request) {
        User owner = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("User", "id", (Object)userPrincipal.getId()));
        UsuarioGiftcard newGiftcard = new UsuarioGiftcard(owner, request.getCardNumber());
        if (this.usuarioGiftcardService.giftcardExist(request.getCardNumber(), request.getNip()).booleanValue()) {
            if (this.usuarioGiftcardRepository.findAllByCardNumber(request.getCardNumber()) != null) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)new ApiResponse(false, "Numero ya se encuentra registrado."));
            }
            try {
                newGiftcard = (UsuarioGiftcard)this.usuarioGiftcardRepository.save((Object)newGiftcard);
            }
            catch (Exception e) {
                return ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al guardar la informaci\u00f3n del giftcard, verifique e intente de nuevo"));
            }
            return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha asignado el giftcard " + newGiftcard.getCardNumber() + " al usuario " + newGiftcard.getOwner().getEmail()));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(false, "Los datos no coinciden"));
    }

    @PutMapping(value={"/giftcards/pago"})
    public ResponseEntity<?> giftcardPayment(@CurrentUser UserPrincipal userPrincipal, @Valid @RequestBody CargoRequest cargoRequest) {
        SierraTokenResponse tokenResponse = null;
        GiftcardResponse response = null;
        try {
            if (this.usuarioGiftcardService.giftcardBalanceValidation(cargoRequest.getCardNumber(), cargoRequest.getAmount()).booleanValue()) {
                tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
                response = this.sierraApi.recarga("Bearer " + tokenResponse.getAccess_token(), cargoRequest.getCardNumber(), new RecargaGiftcardRequest(Double.valueOf(cargoRequest.getAmount() * -1.0), 1, ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)"No hay suficientes fondos"));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response.getGiftcards()));
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/giftcards/registro"})
    public ResponseEntity<?> giftcardRegister(@CurrentUser UserPrincipal userPrincipal, @Valid @RequestBody RegistroRequest registroRequest) {
        SierraTokenResponse tokenResponse = null;
        GiftcardResponse response = null;
        Object list = null;
        NIP nipclass = new NIP();
        String nip = "";
        String cardNumber = "";
        User user = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("El usuario", "identificador", (Object)userPrincipal.getId()));
        try {
            tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
            cardNumber = nipclass.generate();
            nip = nipclass.getRandomNip();
            response = this.sierraApi.registroGiftcard("Bearer " + tokenResponse.getAccess_token(), new RegistroGiftcardRequest(cardNumber, nip, 0, user.getEmail(), nip, Double.valueOf(registroRequest.getAmount()), 1, registroRequest.getPaymentId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, list));
        }
        this.usuarioGiftcardService.saveRecibo(userPrincipal.getId().toString(), registroRequest.getPaymentId(), String.valueOf(((Giftcard)response.getGiftcards().get(0)).getId()), Double.valueOf(registroRequest.getAmount()), cardNumber, 0);
        this.emailService.prepareAndSend(registroRequest.getEmail(), user.getName(), registroRequest.getMessage(), registroRequest.getAmount(), nip, cardNumber);
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response.getGiftcards()));
    }

    @DeleteMapping(value={"/giftcard/{cardnumber}"})
    public ResponseEntity<?> deleteGiftCard(@PathVariable(value="cardnumber") String cardnumber) {
        UsuarioGiftcard giftcard_user = this.usuarioGiftcardRepository.findAllByCardNumber(cardnumber);
        if (this.usuarioGiftcardService.giftcardExist(cardnumber).booleanValue()) {
            try {
                this.usuarioGiftcardRepository.deleteById((Object)giftcard_user.getId());
            }
            catch (Exception e) {
                ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al borrar la informaci\u00f3n de la rewards, verifique e intente de nuevo"));
            }
            return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha borrado el giftcard " + giftcard_user.getCardNumber() + " al usuario " + giftcard_user.getOwner().getEmail()));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(false, "Los datos no coinciden"));
    }

    @PutMapping(value={"/giftcards/cambiopin"})
    public ResponseEntity<?> giftcardChangePin(@CurrentUser UserPrincipal userPrincipal, @Valid @RequestBody CambioPinRequest cambioPinRequest) {
        SierraTokenResponse tokenResponse = null;
        GiftcardResponse response = null;
        try {
            if (this.usuarioGiftcardService.giftcardExist(cambioPinRequest.getCardnumber(), cambioPinRequest.getPin()).booleanValue()) {
                tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
                response = this.sierraApi.cambioPin("Bearer " + tokenResponse.getAccess_token(), new PinRequest(cambioPinRequest.getCardnumber(), cambioPinRequest.getAnteriorPin(), cambioPinRequest.getPin()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)"El pin de la tarjeta no es valido"));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response.getGiftcards()));
    }
}

