/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.facturacion;

import com.sierra.base.config.security.CurrentUser;
import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.domain.request.FacturarRequest;
import com.sierra.base.domain.request.base.FacturacionRequest;
import com.sierra.base.domain.request.base.SierraTokenRequest;
import com.sierra.base.domain.response.FacturaResponse;
import com.sierra.base.domain.response.SierraApi.SierraTokenResponse;
import com.sierra.base.domain.response.SierraApi.TicketResponse;
import com.sierra.base.domain.response.base.ApiResponseData;
import com.sierra.base.endpoint.SierraApi;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController(value="Ticketsv1.0.0")
@RequestMapping(value={"/api"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class TicketRest {
    @Autowired
    private SierraApi sierraApi;

    @GetMapping(value={"/tickets/{ticket}"})
    public ResponseEntity<?> getTicket(@PathVariable(value="ticket") String ticket) {
        SierraTokenResponse tokenResponse = null;
        TicketResponse response = null;
        try {
            tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
            response = this.sierraApi.getTicket("Bearer " + tokenResponse.getAccess_token(), ticket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, null));
        }
        if (response.getMsg().equals("No existe la nota...")) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, response));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, response));
    }

    @PostMapping(value={"/facturar"})
    public ResponseEntity<?> facturarTicket(@CurrentUser UserPrincipal userPrincipal, @Valid @RequestBody FacturacionRequest request) {
        SierraTokenResponse tokenResponse = null;
        FacturaResponse response = null;
        try {
            String correo = request.getCorreo() == null || request.getCorreo().isEmpty() ? userPrincipal.getEmail() : request.getCorreo();
            tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
            response = this.sierraApi.facturarTicket("Bearer " + tokenResponse.getAccess_token(), new FacturarRequest(request.getRfc(), request.getNota(), correo, request.getUsoCFDI()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, null));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, response));
    }
}

