/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.base;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;

/*
 * Exception performing whole class analysis ignored.
 */
public class SequenceGenerator {
    private static final int TOTAL_BITS = 64;
    private static final int EPOCH_BITS = 42;
    private static final int MACHINE_ID_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final int maxMachineId = (int)(Math.pow(2.0, 10.0) - 1.0);
    private static final int maxSequence = (int)(Math.pow(2.0, 12.0) - 1.0);
    private static final long CUSTOM_EPOCH = 1420070400000L;
    private final int machineId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    public SequenceGenerator(int machineId) {
        if (machineId < 0 || machineId > maxMachineId) {
            throw new IllegalArgumentException(String.format("MachineId must be between %d and %d", 0, maxMachineId));
        }
        this.machineId = machineId;
    }

    public SequenceGenerator() {
        this.machineId = this.createMachineId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        long currentTimestamp = SequenceGenerator.timestamp();
        SequenceGenerator sequenceGenerator = this;
        synchronized (sequenceGenerator) {
            if (currentTimestamp < this.lastTimestamp) {
                throw new IllegalStateException("Invalid System Clock!");
            }
            if (currentTimestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & (long)maxSequence;
                if (this.sequence == 0L) {
                    currentTimestamp = this.waitNextMillis(currentTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = currentTimestamp;
        }
        long id = currentTimestamp << 22;
        id |= (long)(this.machineId << 12);
        return id |= this.sequence;
    }

    private static long timestamp() {
        return Instant.now().toEpochMilli() - 1420070400000L;
    }

    private long waitNextMillis(long currentTimestamp) {
        while (currentTimestamp == this.lastTimestamp) {
            currentTimestamp = SequenceGenerator.timestamp();
        }
        return currentTimestamp;
    }

    private int createMachineId() {
        int machineId;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X", mac[i]));
                }
            }
            machineId = sb.toString().hashCode();
        }
        catch (Exception ex) {
            machineId = new SecureRandom().nextInt();
        }
        return machineId &= maxMachineId;
    }
}

