/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.base;

import com.sierra.base.config.APIConstants;
import com.sierra.base.config.security.CurrentUser;
import com.sierra.base.config.security.TokenProvider;
import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.domain.entity.base.AuthProvider;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.domain.request.base.LoginRequest;
import com.sierra.base.domain.request.base.SignUpRequest;
import com.sierra.base.domain.response.base.ApiResponse;
import com.sierra.base.domain.response.base.AuthResponse;
import com.sierra.base.endpoint.MainAPI;
import com.sierra.base.exception.ResourceNotFoundException;
import com.sierra.base.repository.UserRepository;
import com.sierra.base.service.base.EmailService;
import java.net.URI;
import java.util.Date;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/auth"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class AuthController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private MainAPI mainAPI;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private TokenProvider tokenProvider;
    @Autowired
    private EmailService emailService;

    @PostMapping(value={"/login"})
    public ResponseEntity<?> authenticateUser(@Valid @RequestBody LoginRequest loginRequest) {
        APIConstants.USER_EXISTS = false;
        User user = (User)this.userRepository.findByEmail(loginRequest.getEmail()).orElseThrow(() -> new UsernameNotFoundException("No se ha encontrado el usuario " + loginRequest.getEmail() + ", verifique e intente de nuevo"));
        APIConstants.USER_EXISTS = true;
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getEmail(), (Object)loginRequest.getPassword()));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String token = this.tokenProvider.createToken(authentication);
        user.setLastAccess(new Date());
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new AuthResponse(token, user));
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<?> logoutUser(@CurrentUser UserPrincipal userPrincipal) {
        User user = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("User", "id", (Object)userPrincipal.getId()));
        this.userRepository.save((Object)user);
        return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha cerrado sesi\u00f3n exitosamente"));
    }

    @PostMapping(value={"/signup"})
    public ResponseEntity<?> registerUser(@Valid @RequestBody SignUpRequest signUpRequest) {
        Object tokenResponse = null;
        Object response = null;
        Boolean found = false;
        if (this.userRepository.existsByEmail(signUpRequest.getEmail()).booleanValue()) {
            return ResponseEntity.ok().body((Object)new ApiResponse(false, "El correo electr\u00f3nico se encuentra registrado, verifique e intente de nuevo"));
        }
        try {
            User user = new User(signUpRequest.getName(), signUpRequest.getLastName(), signUpRequest.getEmail(), signUpRequest.getDeviceId(), signUpRequest.getDeviceType(), signUpRequest.getPhone());
            user.setPassword(signUpRequest.getPassword());
            user.setProvider(AuthProvider.local);
            user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
            this.emailService.welcome(signUpRequest.getEmail(), signUpRequest.getName());
            try {
                User result = (User)this.userRepository.save((Object)user);
                URI location = ServletUriComponentsBuilder.fromCurrentContextPath().path("/base/session").buildAndExpand(new Object[]{result.getId()}).toUri();
                return ResponseEntity.created((URI)location).body((Object)new ApiResponse(true, "Se ha registrado exitosamente el usuario " + signUpRequest.getEmail()));
            }
            catch (Exception e) {
                return ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al registrar el usuario " + signUpRequest.getEmail() + ", intente de nuevo m\u00e1s tarde"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al registrar el usuario " + signUpRequest.getEmail() + ", intente de nuevo m\u00e1s tarde"));
        }
    }
}

