/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint;

import com.sierra.base.domain.request.AltaRfcRequest;
import com.sierra.base.domain.request.FacturarRequest;
import com.sierra.base.domain.request.PinRequest;
import com.sierra.base.domain.request.RecargaGiftcardRequest;
import com.sierra.base.domain.request.RegistroGiftcardRequest;
import com.sierra.base.domain.request.RewardsRequest;
import com.sierra.base.domain.request.base.SierraTokenRequest;
import com.sierra.base.domain.response.FacturaResponse;
import com.sierra.base.domain.response.SierraApi.ClientResponse;
import com.sierra.base.domain.response.SierraApi.GiftcardResponse;
import com.sierra.base.domain.response.SierraApi.RewardsResponse;
import com.sierra.base.domain.response.SierraApi.SierraTokenResponse;
import com.sierra.base.domain.response.SierraApi.TicketResponse;
import com.sierra.base.domain.response.SierraApi.UsoCFDIResponse;
import com.sierra.base.endpoint.SierraApi;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="SierraApi", url="${SierraApi.urls.SierraApiUrl}", configuration={Configuration.class})
public interface SierraApi {
    public static final String AUTH_TOKEN = "Authorization";

    @RequestMapping(value={"/gettoken"}, produces={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    public SierraTokenResponse getToken(@RequestBody SierraTokenRequest var1);

    @RequestMapping(value={"/giftcards"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public GiftcardResponse getAllGiftcards(@RequestHeader(value="Authorization") String var1);

    @RequestMapping(value={"/giftcards/{cardnumber}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public GiftcardResponse getGiftcard(@RequestHeader(value="Authorization") String var1, @PathVariable(value="cardnumber") String var2);

    @RequestMapping(value={"/rfcclientes"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public ClientResponse getAllClients(@RequestHeader(value="Authorization") String var1);

    @RequestMapping(value={"/rfcclientes/{rfc}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public ClientResponse getClient(@RequestHeader(value="Authorization") String var1, @PathVariable(value="rfc") String var2);

    @RequestMapping(value={"/rfcclientes/{rfc}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.PUT})
    public ClientResponse saveRFC(@RequestHeader(value="Authorization") String var1, @PathVariable(value="rfc") String var2, @RequestBody AltaRfcRequest var3);

    @RequestMapping(value={"/rewards"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public RewardsResponse getAllRewards(@RequestHeader(value="Authorization") String var1);

    @RequestMapping(value={"/rewards/{cardnumber}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public RewardsResponse getReward(@RequestHeader(value="Authorization") String var1, @PathVariable(value="cardnumber") String var2);

    @RequestMapping(value={"/giftcards/{cardnumber}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.PUT})
    public GiftcardResponse recarga(@RequestHeader(value="Authorization") String var1, @PathVariable(value="cardnumber") String var2, @RequestBody RecargaGiftcardRequest var3);

    @RequestMapping(value={"/giftcards"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.PUT})
    public GiftcardResponse cambioPin(@RequestHeader(value="Authorization") String var1, @RequestBody PinRequest var2);

    @RequestMapping(value={"/tickets/{folio}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public TicketResponse getTicketPdv(@RequestHeader(value="Authorization") String var1, @PathVariable(value="folio") String var2);

    @RequestMapping(value={"/rewards"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.POST})
    public RewardsResponse postRewards(@RequestHeader(value="Authorization") String var1, @RequestBody RewardsRequest var2);

    @RequestMapping(value={"/giftcards"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.POST})
    public GiftcardResponse registroGiftcard(@RequestHeader(value="Authorization") String var1, @RequestBody RegistroGiftcardRequest var2);

    @RequestMapping(value={"/usocfdi"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public UsoCFDIResponse getUsosCFDI(@RequestHeader(value="Authorization") String var1);

    @RequestMapping(value={"/rfcticket/{ticket}"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.GET})
    public TicketResponse getTicket(@RequestHeader(value="Authorization") String var1, @PathVariable(value="ticket") String var2);

    @RequestMapping(value={"/rfcfacturar"}, produces={"application/json;charset=utf-8"}, method={RequestMethod.POST})
    public FacturaResponse facturarTicket(@RequestHeader(value="Authorization") String var1, @RequestBody FacturarRequest var2);
}

