/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.domain.entity.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sierra.base.domain.entity.base.AuditListener;
import com.sierra.base.domain.entity.base.Auditable;
import com.sierra.base.domain.entity.base.AuthProvider;
import com.sierra.base.domain.entity.base.EntityBase;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;

@Entity
@EntityListeners(value={AuditListener.class})
@Table(name="users", uniqueConstraints={@UniqueConstraint(columnNames={"email"})})
public class User
extends EntityBase
implements Auditable {
    @Column(nullable=false)
    private String name;
    private String lastName;
    @Email
    @Column(nullable=false)
    private String email;
    private String phone;
    @Column(nullable=false)
    private Boolean emailVerified = false;
    @JsonIgnore
    @Column(columnDefinition="DATETIME")
    private Date registerDate;
    @JsonIgnore
    @Column(columnDefinition="DATETIME")
    private Date lastAccess;
    private String deviceId;
    private String deviceType;
    private boolean enabled;
    @JsonIgnore
    private String password;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private AuthProvider provider;
    private String providerId;
    @Transient
    private String completeName = this.name + " " + this.lastName;

    public User() {
    }

    @PostLoad
    void fillTransient() {
        this.completeName = this.name + " " + this.lastName;
    }

    public User(String name, String lastName, String email, String deviceId, String deviceType, String phone) {
        this.name = name;
        this.lastName = lastName;
        this.email = email;
        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.lastAccess = new Date();
        this.registerDate = new Date();
        this.enabled = true;
        this.phone = phone;
    }

    public User(String name, String lastName, String email) {
        this.name = name;
        this.lastName = lastName;
        this.email = email;
        this.lastAccess = new Date();
        this.registerDate = new Date();
        this.enabled = true;
    }

    public void updateAdminData(String name, String lastName, String email, String phone) {
        this.name = name;
        this.lastName = lastName;
        this.email = email;
        this.phone = phone;
        this.registerDate = new Date();
        this.enabled = true;
    }

    public String getCompleteName() {
        if (this.lastName == null) {
            return this.name;
        }
        return this.name + " " + this.lastName;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public Date getRegisterDate() {
        return this.registerDate;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthProvider getProvider() {
        return this.provider;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProvider(AuthProvider provider) {
        this.provider = provider;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public void setCompleteName(String completeName) {
        this.completeName = completeName;
    }
}

