/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.config.security.oauth2;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.sierra.base.util.CookieUtils;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.stereotype.Component;

@Component
public class HttpCookieOAuth2AuthorizationRequestRepository
implements AuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    public static final String OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME = "oauth2_auth_request";
    public static final String REDIRECT_URI_PARAM_COOKIE_NAME = "redirect_uri";
    private static final int cookieExpireSeconds = 180;

    public OAuth2AuthorizationRequest loadAuthorizationRequest(HttpServletRequest request) {
        return CookieUtils.getCookie((HttpServletRequest)request, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME).map(cookie -> (OAuth2AuthorizationRequest)CookieUtils.deserialize((Cookie)cookie, OAuth2AuthorizationRequest.class)).orElse(null);
    }

    public void saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request, HttpServletResponse response) {
        if (authorizationRequest == null) {
            CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME);
            CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)REDIRECT_URI_PARAM_COOKIE_NAME);
            return;
        }
        CookieUtils.addCookie((HttpServletResponse)response, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME, (String)CookieUtils.serialize((Object)authorizationRequest), (int)180);
        String redirectUriAfterLogin = request.getParameter(REDIRECT_URI_PARAM_COOKIE_NAME);
        if (StringUtils.isNotBlank((CharSequence)redirectUriAfterLogin)) {
            CookieUtils.addCookie((HttpServletResponse)response, (String)REDIRECT_URI_PARAM_COOKIE_NAME, (String)redirectUriAfterLogin, (int)180);
        }
    }

    public OAuth2AuthorizationRequest removeAuthorizationRequest(HttpServletRequest request) {
        return this.loadAuthorizationRequest(request);
    }

    public void removeAuthorizationRequestCookies(HttpServletRequest request, HttpServletResponse response) {
        CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME);
        CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)REDIRECT_URI_PARAM_COOKIE_NAME);
    }
}

