/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.config.security.oauth2;

import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.config.security.oauth2.user.OAuth2UserInfo;
import com.sierra.base.config.security.oauth2.user.OAuth2UserInfoFactory;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.exception.OAuth2AuthenticationProcessingException;
import com.sierra.base.repository.UserRepository;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CustomOAuth2UserService
extends DefaultOAuth2UserService {
    @Autowired
    private UserRepository userRepository;

    public OAuth2User loadUser(OAuth2UserRequest oAuth2UserRequest) throws OAuth2AuthenticationException {
        OAuth2User oAuth2User = super.loadUser(oAuth2UserRequest);
        try {
            return this.processOAuth2User(oAuth2UserRequest, oAuth2User);
        }
        catch (AuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalAuthenticationServiceException(ex.getMessage(), ex.getCause());
        }
    }

    private OAuth2User processOAuth2User(OAuth2UserRequest oAuth2UserRequest, OAuth2User oAuth2User) {
        User user;
        OAuth2UserInfo oAuth2UserInfo = OAuth2UserInfoFactory.getOAuth2UserInfo((String)oAuth2UserRequest.getClientRegistration().getRegistrationId(), (Map)oAuth2User.getAttributes());
        if (StringUtils.isEmpty((Object)oAuth2UserInfo.getEmail())) {
            throw new OAuth2AuthenticationProcessingException("Email not found from OAuth2 provider");
        }
        Optional userOptional = this.userRepository.findByEmail(oAuth2UserInfo.getEmail());
        if (userOptional.isPresent()) {
            user = (User)userOptional.get();
            user = this.updateExistingUser(user, oAuth2UserInfo);
        } else {
            user = this.registerNewUser(oAuth2UserRequest, oAuth2UserInfo);
        }
        return UserPrincipal.create((User)user, (Map)oAuth2User.getAttributes());
    }

    private User registerNewUser(OAuth2UserRequest oAuth2UserRequest, OAuth2UserInfo oAuth2UserInfo) {
        User user = new User();
        user.setName(oAuth2UserInfo.getName());
        user.setEmail(oAuth2UserInfo.getEmail());
        return (User)this.userRepository.save((Object)user);
    }

    private User updateExistingUser(User existingUser, OAuth2UserInfo oAuth2UserInfo) {
        existingUser.setName(oAuth2UserInfo.getName());
        return (User)this.userRepository.save((Object)existingUser);
    }
}

