/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.config.security;

import com.sierra.base.config.AppProperties;
import com.sierra.base.config.security.UserPrincipal;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class TokenProvider {
    @Autowired
    private PasswordEncoder passwordEncoder;
    private static final Logger logger = LoggerFactory.getLogger(TokenProvider.class);
    private AppProperties appProperties;

    public TokenProvider(AppProperties appProperties) {
        this.appProperties = appProperties;
    }

    public String createToken(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Date now = new Date();
        Date expiryDate = new Date(now.getTime() + this.appProperties.getAuth().getTokenExpirationMsec());
        return Jwts.builder().setSubject(Long.toString(userPrincipal.getId())).setIssuedAt(new Date()).setExpiration(expiryDate).signWith(SignatureAlgorithm.HS512, this.appProperties.getAuth().getTokenSecret()).compact();
    }

    public String createRefreshToken(Authentication authentication) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        return this.passwordEncoder.encode((CharSequence)(userPrincipal.getId().toString() + System.currentTimeMillis()));
    }

    public Long getUserIdFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.appProperties.getAuth().getTokenSecret()).parseClaimsJws(token).getBody();
        return Long.parseLong(claims.getSubject());
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.appProperties.getAuth().getTokenSecret()).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException ex) {
            logger.error("Invalid JWT signature");
        }
        catch (MalformedJwtException ex) {
            logger.error("Invalid JWT token");
        }
        catch (ExpiredJwtException ex) {
            logger.error("Expired JWT token");
        }
        catch (UnsupportedJwtException ex) {
            logger.error("Unsupported JWT token");
        }
        catch (IllegalArgumentException ex) {
            logger.error("JWT claims string is empty.");
        }
        return false;
    }
}

