/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.config.security;

import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.exception.ResourceNotFoundException;
import com.sierra.base.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    @Autowired
    UserRepository userRepository;

    @Transactional
    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        User user = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new UsernameNotFoundException("User not found with email : " + email));
        return UserPrincipal.create((User)user);
    }

    @Transactional
    public UserDetails loadUserById(Long id) {
        User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("User", "id", (Object)id));
        return UserPrincipal.create((User)user);
    }
}

