/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.service.base;

import com.sierra.base.config.StorageProperties;
import com.sierra.base.domain.response.base.FileResponse;
import com.sierra.base.exception.FileNotFoundException;
import com.sierra.base.exception.StorageException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileSystemStorageService {
    private final Path rootLocation;
    private MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();

    @Autowired
    public FileSystemStorageService(StorageProperties properties) {
        this.rootLocation = Paths.get(properties.getLocation(), new String[0]);
    }

    @PostConstruct
    public void init() {
        try {
            Files.createDirectories(this.rootLocation, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StorageException("Could not initialize storage location", (Throwable)e);
        }
    }

    public String store(MultipartFile file, String path, String fileName) {
        if (file == null) {
            return null;
        }
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(46, file.getOriginalFilename().length()));
        String fileNewName = StringUtils.cleanPath((String)(path + fileName + fileType));
        try {
            Files.createDirectories(this.rootLocation.resolve(path), new FileAttribute[0]);
            if (file.isEmpty()) {
                return "";
            }
            if (fileNewName.contains("..")) {
                throw new StorageException("Cannot store file with relative path outside current directory " + fileName);
            }
            try (InputStream inputStream = file.getInputStream();){
                Files.copy(inputStream, this.rootLocation.resolve(fileNewName), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to store file " + fileName, (Throwable)e);
        }
        return fileNewName;
    }

    public Path load(String filename) {
        return this.rootLocation.resolve(filename);
    }

    public FileResponse loadAsResource(String filename) {
        try {
            Path pathFile = this.load(filename);
            UrlResource resource = new UrlResource(pathFile.toUri());
            if (resource.exists() || resource.isReadable()) {
                File file = resource.getFile();
                return new FileResponse(this.readFileToByteArray(file), Files.probeContentType(pathFile));
            }
            throw new FileNotFoundException("Could not read file: " + filename);
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException("Could not read file: " + filename, (Throwable)e);
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not read file: " + filename, (Throwable)e);
        }
    }

    private byte[] readFileToByteArray(File file) {
        FileInputStream fis = null;
        byte[] bArray = new byte[(int)file.length()];
        try {
            fis = new FileInputStream(file);
            fis.read(bArray);
            fis.close();
        }
        catch (IOException ioExp) {
            ioExp.printStackTrace();
        }
        return bArray;
    }
}

