/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.service.base;

import com.sierra.base.domain.entity.base.SystemParameter;
import com.sierra.base.repository.SystemParameterRepository;
import com.sierra.base.service.base.MailContentBuilder;
import com.sierra.base.util.CodeGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    @Autowired
    private JavaMailSender mailSender;
    private MimeMessage message;
    @Autowired
    private SystemParameterRepository systemParameterRepository;
    @Autowired
    private MailContentBuilder mailContentBuilder;
    @Value(value="${spring.mail.username}")
    private String fromAddress;

    private void sendMail(String messageBody, String subject, String toAddress, String[] ccAddressString) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void sendMail(String messageBody, String subject, String[] toAddresses) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void sendMail(String messageBody, String subject, String[] toAddresses, List<File> attachments) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void printAddress(String[] toAddresses) {
        for (String toAddress : toAddresses) {
            System.out.println("enviara correo a: " + toAddress);
        }
    }

    private MimeMessageHelper createMimeMessage(String messageBody, String subject, String[] toAddresses) throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(this.message, true, "UTF-8");
        helper.setFrom(this.fromAddress);
        helper.setSubject(subject);
        helper.setTo(toAddresses);
        helper.setText(messageBody, true);
        return helper;
    }

    private MimeMessageHelper createMimeMessage(String messageBody, String subject, String toAddress) throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(this.message, true, "UTF-8");
        helper.setFrom(this.fromAddress);
        helper.setSubject(subject);
        helper.setTo(toAddress);
        helper.setText(messageBody, true);
        return helper;
    }

    private void sendMail(String messageBody, String subject, String toAddress, List<File> attachments) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void sendMail(String messageBody, String subject, String toAddress, File attachment) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public void welcomeEmail(String email) {
        SystemParameter emailValues = this.systemParameterRepository.findFirstByPropertyKey("EMAIL_FOR_NEW_USER");
        String emailFormat = emailValues.getValue();
        String subject = emailValues.getOptionalValue();
        if (emailFormat != null) {
            this.sendMail(emailFormat, subject, email, new String[0]);
        }
    }

    public void sendSimpleMessage(String to, String subject, String from, String msg) throws Exception {
        this.message = this.mailSender.createMimeMessage();
        SimpleMailMessage mgg = new SimpleMailMessage();
        MimeMessageHelper helper = new MimeMessageHelper(this.message, true, "UTF-8");
        BufferedImage code = CodeGenerator.generateEAN13BarcodeImage((String)"1234567891231");
        helper.setFrom(this.fromAddress);
        helper.setSubject(subject);
        helper.setTo(to);
        HashMap<String, String> mapInlineImages = new HashMap<String, String>();
        mapInlineImages.put("image1", "C:\\Users\\Naomi\\Downloads\\QRCODES\\qrTest.png");
        StringBuffer body = new StringBuffer("<html>Te han enviado un certificado.<br>");
        body.append("De: " + from + "<br>");
        body.append("Mensaje:" + msg + "<br>");
        body.append("<img src=\"cid:image1\" width=\"30%\" height=\"30%\" /><br>");
        body.append("N\u00famero de certificado : 1234567891231.<br> ");
        body.append("</html>");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)body.toString(), "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (mapInlineImages != null && mapInlineImages.size() > 0) {
            Set setImageID = mapInlineImages.keySet();
            for (String contentId : setImageID) {
                MimeBodyPart imagePart = new MimeBodyPart();
                imagePart.setHeader("Content-ID", "<" + contentId + ">");
                imagePart.setDisposition("inline");
                String imageFilePath = (String)mapInlineImages.get(contentId);
                try {
                    imagePart.attachFile(imageFilePath);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                multipart.addBodyPart((BodyPart)imagePart);
            }
        }
        this.message.setContent((Multipart)multipart);
        this.mailSender.send(this.message);
    }

    public void prepareAndSend(String recipient, String from, String message, String monto, String nip, String cardnumbr) {
        MimeMessagePreparator messagePreparator = mimeMessage -> {
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage);
            messageHelper.setFrom("sample@naomi.com");
            messageHelper.setTo(recipient);
            messageHelper.setSubject("\u00a1Has recibido una tarjeta de regalo!");
            String content = this.mailContentBuilder.buildGiftcardMail(from, message, monto, from, nip, cardnumbr);
            messageHelper.setText(content, true);
        };
        try {
            this.mailSender.send(messagePreparator);
        }
        catch (MailException mailException) {
            // empty catch block
        }
    }

    public void welcome(String recipient, String to) {
        MimeMessagePreparator messagePreparator = mimeMessage -> {
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage);
            messageHelper.setFrom("sample@naomi.com");
            messageHelper.setTo(recipient);
            messageHelper.setSubject("\u00a1Bienvenido!");
            String content = this.mailContentBuilder.buildWelcomeMail(to);
            messageHelper.setText(content, true);
        };
        try {
            this.mailSender.send(messagePreparator);
        }
        catch (MailException mailException) {
            // empty catch block
        }
    }

    public void reciboPaypal(String to, String name, String folio, String descripcion, String monto, String fecha) {
        MimeMessagePreparator messagePreparator = mimeMessage -> {
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage);
            messageHelper.setFrom("sample@naomi.com");
            messageHelper.setTo(to);
            messageHelper.setSubject("Recibo de pago: " + folio);
            String content = this.mailContentBuilder.buildReciboMail(name, folio, descripcion, monto, fecha);
            messageHelper.setText(content, true);
        };
        try {
            this.mailSender.send(messagePreparator);
        }
        catch (MailException mailException) {
            // empty catch block
        }
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public void setMessage(MimeMessage message) {
        this.message = message;
    }

    static /* synthetic */ MimeMessage access$002(EmailService x0, MimeMessage x1) {
        x0.message = x1;
        return x0.message;
    }

    static /* synthetic */ JavaMailSender access$100(EmailService x0) {
        return x0.mailSender;
    }

    static /* synthetic */ MimeMessage access$000(EmailService x0) {
        return x0.message;
    }

    static /* synthetic */ MimeMessageHelper access$200(EmailService x0, String x1, String x2, String x3) throws MessagingException {
        return x0.createMimeMessage(x1, x2, x3);
    }

    static /* synthetic */ void access$300(EmailService x0, String[] x1) {
        x0.printAddress(x1);
    }

    static /* synthetic */ MimeMessageHelper access$400(EmailService x0, String x1, String x2, String[] x3) throws MessagingException {
        return x0.createMimeMessage(x1, x2, x3);
    }
}

