/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.rewards;

import com.sierra.base.config.security.CurrentUser;
import com.sierra.base.config.security.UserPrincipal;
import com.sierra.base.domain.entity.rewards.RewardsCard;
import com.sierra.base.domain.entity.rewards.UsuarioRewards;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.domain.request.AssignGiftcardRequest;
import com.sierra.base.domain.response.base.ApiResponse;
import com.sierra.base.domain.response.base.ApiResponseData;
import com.sierra.base.endpoint.SierraApi;
import com.sierra.base.exception.ResourceNotFoundException;
import com.sierra.base.repository.UserRepository;
import com.sierra.base.repository.UsuarioRewardsRepository;
import com.sierra.base.service.base.EmailService;
import com.sierra.base.service.rewards.UsuarioRewardsService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController(value="Rewardsv1.0.0")
@RequestMapping(value={"/api"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class RewardsRest {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SierraApi sierraApi;
    @Autowired
    private EmailService emailService;
    @Autowired
    private UsuarioRewardsRepository usuarioRewardsRepository;
    @Autowired
    private UsuarioRewardsService usuarioRewardsService;

    @GetMapping(value={"/rewards/ownedcard"})
    public ResponseEntity<?> getRewardsCard(@CurrentUser UserPrincipal userPrincipal) {
        RewardsCard card = null;
        try {
            if (this.usuarioRewardsRepository.findByOwner_Id(userPrincipal.getId()) != null) {
                card = this.usuarioRewardsService.getUsersRewards(userPrincipal.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (card == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)card));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)card));
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/rewards"})
    public ResponseEntity<?> assignRewardsCard(@CurrentUser UserPrincipal userPrincipal, @RequestPart(value="request") @Valid AssignGiftcardRequest request) {
        User owner = (User)this.userRepository.findById((Object)userPrincipal.getId()).orElseThrow(() -> new ResourceNotFoundException("User", "id", (Object)userPrincipal.getId()));
        UsuarioRewards newRewards = new UsuarioRewards(owner, request.getCardNumber());
        if (this.usuarioRewardsService.rewardsExist(request.getCardNumber()).booleanValue()) {
            if (this.usuarioRewardsService.rewardsAvailable(request.getCardNumber())) {
                try {
                    newRewards = (UsuarioRewards)this.usuarioRewardsRepository.save((Object)newRewards);
                }
                catch (Exception e) {
                    ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al guardar la informaci\u00f3n de la rewards, verifique e intente de nuevo"));
                }
                return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha asignado el rewards " + newRewards.getCardNumber() + " al usuario " + newRewards.getOwner().getEmail()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(false, "La tarjeta ya se encuentra asignada"));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(false, "Los datos no coinciden"));
    }

    @DeleteMapping(value={"/rewards/{cardnumber}"})
    public ResponseEntity<?> deleteRewardsCard(@PathVariable(value="cardnumber") String cardnumber) {
        UsuarioRewards newRewards = this.usuarioRewardsRepository.findByCardNumber(cardnumber);
        if (this.usuarioRewardsService.rewardsExist(cardnumber).booleanValue()) {
            if (!this.usuarioRewardsService.rewardsAvailable(cardnumber)) {
                try {
                    this.usuarioRewardsRepository.deleteById((Object)newRewards.getId());
                }
                catch (Exception e) {
                    ResponseEntity.ok().body((Object)new ApiResponse(false, "Ocurri\u00f3 un problema al borrar la informaci\u00f3n de la rewards, verifique e intente de nuevo"));
                }
                return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha borrado el rewards " + newRewards.getCardNumber() + " al usuario " + newRewards.getOwner().getEmail()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(false, "La tarjeta no se encuentra asignada"));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(false, "Los datos no coinciden"));
    }
}

