/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.facturacion;

import com.sierra.base.domain.request.AltaRfcRequest;
import com.sierra.base.domain.request.base.SierraTokenRequest;
import com.sierra.base.domain.response.SierraApi.ClientResponse;
import com.sierra.base.domain.response.SierraApi.SierraTokenResponse;
import com.sierra.base.domain.response.base.ApiResponseData;
import com.sierra.base.endpoint.SierraApi;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController(value="Clientv1.0.0")
@RequestMapping(value={"/api"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class ClientRest {
    @Autowired
    private SierraApi sierraApi;

    @GetMapping(value={"/rfcclientes/{rfc}"})
    public ResponseEntity<?> getClient(@PathVariable(value="rfc") String rfc) {
        SierraTokenResponse tokenResponse = null;
        ClientResponse response = null;
        try {
            tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
            response = this.sierraApi.getClient("Bearer " + tokenResponse.getAccess_token(), rfc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, null));
        }
        if (!response.getCount().equals("0")) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response.getClients()));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)response.getClients()));
    }

    @PutMapping(value={"/rfcclientes/{rfc}"})
    public ResponseEntity<?> registrarRFC(@PathVariable(value="rfc") String rfc, @Valid @RequestBody AltaRfcRequest altaRfcRequest) {
        SierraTokenResponse tokenResponse = null;
        ClientResponse response = null;
        try {
            tokenResponse = this.sierraApi.getToken(new SierraTokenRequest("servicesfrc", "4TASzQRV-BD-mJ#8", "password"));
            response = this.sierraApi.saveRFC("Bearer " + tokenResponse.getAccess_token(), rfc, altaRfcRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(false, null));
        }
        if (!response.getCount().equals("0")) {
            return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)response.getClients()));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(false, (Object)response.getClients()));
    }
}

