/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.endpoint.base;

import com.sierra.base.domain.entity.base.VerificationNumber;
import com.sierra.base.domain.entity.user.User;
import com.sierra.base.domain.response.base.ApiResponse;
import com.sierra.base.domain.response.base.ApiResponseData;
import com.sierra.base.exception.ResourceNotFoundException;
import com.sierra.base.repository.UserRepository;
import com.sierra.base.repository.VerificationNumberRepository;
import com.sierra.base.service.base.VerificationNumberService;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController
@RequestMapping(value={"/api"}, produces={"application/vnd.certuit-v1.0.0+json"})
public class RecoverPasswordRest {
    private static final String PHONE = "+15867823251";
    private static final String TOKEN = "My@874BmKmaQRf-!";
    @Autowired
    private VerificationNumberRepository verificationNumberRepository;
    @Autowired
    private VerificationNumberService verificationNumberService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @PostMapping(value={"/sms"})
    public ResponseEntity<?> getConfirmationCode(@Valid @NotBlank @RequestPart(value="phone") String phone) {
        if (!this.userRepository.existsByPhone(phone).booleanValue()) {
            return ResponseEntity.ok().body((Object)new ApiResponse(false, "El n\u00famero de tel\u00e9fono no coincide con ning\u00fan usuario registrado. Verifiqu\u00e9 e intent\u00e9 de nuevo"));
        }
        String completePhone = "+52" + phone;
        VerificationNumber verificationNumber = new VerificationNumber(completePhone, VerificationNumber.generateCode());
        try {
            Message.creator((PhoneNumber)new PhoneNumber(completePhone), (PhoneNumber)new PhoneNumber(PHONE), (String)("Verification code: " + String.format("%04d", verificationNumber.getCode()))).create();
            verificationNumber = (VerificationNumber)this.verificationNumberRepository.save((Object)verificationNumber);
        }
        catch (Exception e) {
            return ResponseEntity.ok().body((Object)new ApiResponse(true, "No fue posible enviar el mensaje de texto."));
        }
        return ResponseEntity.ok().body((Object)new ApiResponseData(true, (Object)verificationNumber));
    }

    @PostMapping(value={"/recover"})
    public ResponseEntity<?> recoverPassword(@Valid @NotBlank @RequestPart(value="phone") String phone, @RequestPart(value="code") String code, @RequestPart(value="password") String newPassword) {
        String completePhone = "+52" + phone;
        VerificationNumber verificationNumber = this.verificationNumberService.findPhoneNumber(completePhone);
        if (verificationNumber.getCode() != Integer.valueOf(code).intValue()) {
            return ResponseEntity.ok().body((Object)new ApiResponse(false, "El n\u00famero de verificaci\u00f3n no coincide."));
        }
        User user = (User)this.userRepository.findFirstByPhone(phone).orElseThrow(() -> new ResourceNotFoundException("EL usuario", "tel\u00e9fono", (Object)phone));
        user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        this.userRepository.save((Object)user);
        this.verificationNumberRepository.delete((Object)verificationNumber);
        return ResponseEntity.ok().body((Object)new ApiResponse(true, "Se ha actualizado la contrase\u00f1a exitosamente"));
    }
}

