/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.config.security.oauth2;

import com.sierra.base.config.security.oauth2.HttpCookieOAuth2AuthorizationRequestRepository;
import com.sierra.base.util.CookieUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class OAuth2AuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @Autowired
    HttpCookieOAuth2AuthorizationRequestRepository httpCookieOAuth2AuthorizationRequestRepository;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String targetUrl = CookieUtils.getCookie((HttpServletRequest)request, (String)"redirect_uri").map(Cookie::getValue).orElse("/");
        targetUrl = UriComponentsBuilder.fromUriString((String)targetUrl).queryParam("error", new Object[]{exception.getLocalizedMessage()}).build().toUriString();
        this.httpCookieOAuth2AuthorizationRequestRepository.removeAuthorizationRequestCookies(request, response);
        this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
    }
}

