/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.base.config.security;

import com.sierra.base.config.APIConstants;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class RestAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(RestAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException e) throws IOException {
        if (!APIConstants.USER_EXISTS.booleanValue()) {
            logger.error("Responding with user not found error. Message - {}", (Object)e.getMessage());
            httpServletResponse.sendError(404, "El usuario no existe.");
        } else {
            logger.error("Responding with unauthorized error. Message - {}", (Object)e.getMessage());
            httpServletResponse.sendError(401, "La contrase\u00f1a no coincide.");
        }
    }
}

