/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.multimedia;

import java.io.File;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.imageio.stream.FileImageOutputStream;
import javax.servlet.ServletContext;
import org.primefaces.model.CroppedImage;

@ManagedBean
public class CropperView {
    private CroppedImage croppedImage;
    private String newImageName;

    public CroppedImage getCroppedImage() {
        return this.croppedImage;
    }

    public void setCroppedImage(CroppedImage croppedImage) {
        this.croppedImage = croppedImage;
    }

    public void crop() {
        if (this.croppedImage == null) {
            return;
        }
        this.setNewImageName(this.getRandomImageName());
        ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        String newFileName = servletContext.getRealPath("") + File.separator + "resources" + File.separator + "demo" + File.separator + "images" + File.separator + "crop" + File.separator + this.getNewImageName() + ".jpg";
        try {
            FileImageOutputStream imageOutput = new FileImageOutputStream(new File(newFileName));
            imageOutput.write(this.croppedImage.getBytes(), 0, this.croppedImage.getBytes().length);
            imageOutput.close();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error", "Cropping failed."));
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Success", "Cropping finished."));
    }

    private String getRandomImageName() {
        int i = (int)(Math.random() * 100000.0);
        return String.valueOf(i);
    }

    public String getNewImageName() {
        return this.newImageName;
    }

    public void setNewImageName(String newImageName) {
        this.newImageName = newImageName;
    }
}

