/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.dnd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import org.primefaces.event.DragDropEvent;
import org.primefaces.ultima.domain.Car;
import org.primefaces.ultima.service.CarService;

@ManagedBean(name="dndCarsView")
@ViewScoped
public class DNDCarsView
implements Serializable {
    @ManagedProperty(value="#{carService}")
    private CarService service;
    private List<Car> cars;
    private List<Car> droppedCars;
    private Car selectedCar;

    @PostConstruct
    public void init() {
        this.cars = this.service.createCars(9);
        this.droppedCars = new ArrayList();
    }

    public void onCarDrop(DragDropEvent ddEvent) {
        Car car = (Car)ddEvent.getData();
        this.droppedCars.add(car);
        this.cars.remove(car);
    }

    public void setService(CarService service) {
        this.service = service;
    }

    public List<Car> getCars() {
        return this.cars;
    }

    public List<Car> getDroppedCars() {
        return this.droppedCars;
    }

    public Car getSelectedCar() {
        return this.selectedCar;
    }

    public void setSelectedCar(Car selectedCar) {
        this.selectedCar = selectedCar;
    }
}

