/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.datatable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortOrder;
import org.primefaces.ultima.domain.Car;
import org.primefaces.ultima.view.data.datatable.LazySorter;

public class LazyCarDataModel
extends LazyDataModel<Car> {
    private List<Car> datasource;

    public LazyCarDataModel(List<Car> datasource) {
        this.datasource = datasource;
    }

    public Car getRowData(String rowKey) {
        for (Car car : this.datasource) {
            if (!car.getId().equals(rowKey)) continue;
            return car;
        }
        return null;
    }

    public Object getRowKey(Car car) {
        return car.getId();
    }

    public List<Car> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        ArrayList<Car> data = new ArrayList<Car>();
        for (Car car : this.datasource) {
            boolean match = true;
            if (filters != null) {
                Iterator<String> it = filters.keySet().iterator();
                while (it.hasNext()) {
                    try {
                        String filterProperty = it.next();
                        Object filterValue = filters.get(filterProperty);
                        String fieldValue = String.valueOf(car.getClass().getField(filterProperty).get(car));
                        if (filterValue == null || fieldValue.startsWith(filterValue.toString())) {
                            match = true;
                            continue;
                        }
                        match = false;
                        break;
                    }
                    catch (Exception e) {
                        match = false;
                    }
                }
            }
            if (!match) continue;
            data.add(car);
        }
        if (sortField != null) {
            Collections.sort(data, new LazySorter(sortField, sortOrder));
        }
        int dataSize = data.size();
        this.setRowCount(dataSize);
        if (dataSize > pageSize) {
            try {
                return data.subList(first, first + pageSize);
            }
            catch (IndexOutOfBoundsException e) {
                return data.subList(first, first + dataSize % pageSize);
            }
        }
        return data;
    }
}

