/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.datatable;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import org.primefaces.ultima.domain.Car;
import org.primefaces.ultima.service.CarService;

@ManagedBean(name="dtFilterView")
@ViewScoped
public class FilterView
implements Serializable {
    private List<Car> cars;
    private List<Car> filteredCars;
    @ManagedProperty(value="#{carService}")
    private CarService service;

    @PostConstruct
    public void init() {
        this.cars = this.service.createCars(10);
    }

    public boolean filterByPrice(Object value, Object filter, Locale locale) {
        String filterText;
        String string = filterText = filter == null ? null : filter.toString().trim();
        if (filterText == null || filterText.equals("")) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return ((Comparable)value).compareTo(Integer.valueOf(filterText)) > 0;
    }

    public List<String> getBrands() {
        return this.service.getBrands();
    }

    public List<String> getColors() {
        return this.service.getColors();
    }

    public List<Car> getCars() {
        return this.cars;
    }

    public List<Car> getFilteredCars() {
        return this.filteredCars;
    }

    public void setFilteredCars(List<Car> filteredCars) {
        this.filteredCars = filteredCars;
    }

    public void setService(CarService service) {
        this.service = service;
    }
}

