/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view;

import java.io.Serializable;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import org.primefaces.event.timeline.TimelineSelectEvent;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineModel;

@ManagedBean(name="basicTimelineView")
@ViewScoped
public class TimeLineView
implements Serializable {
    private TimelineModel model;
    private boolean selectable = true;
    private boolean zoomable = true;
    private boolean moveable = true;
    private boolean stackEvents = true;
    private String eventStyle = "box";
    private boolean axisOnTop;
    private boolean showCurrentTime = true;
    private boolean showNavigation = false;

    @PostConstruct
    protected void initialize() {
        this.model = new TimelineModel();
        Calendar cal = Calendar.getInstance();
        cal.set(2014, 5, 12, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"PrimeUI 1.1", cal.getTime()));
        cal.set(2014, 9, 11, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Primefaces 5.1.3", cal.getTime()));
        cal.set(2015, 11, 8, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"PrimeUI 2.2", cal.getTime()));
        cal.set(2015, 2, 10, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Sentinel-Layout 1.1", cal.getTime()));
        cal.set(2015, 3, 3, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Spark-Layout 1.0", cal.getTime()));
        cal.set(2015, 4, 15, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Ronin-Layout 1.0", cal.getTime()));
        cal.set(2015, 6, 10, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Modena-Layout 1.0", cal.getTime()));
        cal.set(2015, 5, 15, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Rio-Layout 1.0", cal.getTime()));
        cal.set(2015, 8, 4, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Adamantium-Layout 1.0", cal.getTime()));
        cal.set(2015, 11, 14, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Titan-Layout 1.0", cal.getTime()));
        cal.set(2015, 9, 12, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Volt-Layout 1.0", cal.getTime()));
        cal.set(2016, 0, 28, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Atlas-Layout 1.0", cal.getTime()));
        cal.set(2016, 1, 24, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"PrimeUI 4.1.0", cal.getTime()));
        cal.set(2016, 1, 29, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"Primefaces 5.3.8", cal.getTime()));
        cal.set(2016, 1, 29, 0, 0, 0);
        this.model.add(new TimelineEvent((Object)"PrimeNG 0.5", cal.getTime()));
    }

    public void onSelect(TimelineSelectEvent e) {
        TimelineEvent timelineEvent = e.getTimelineEvent();
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_INFO, "Selected event:", timelineEvent.getData().toString());
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public TimelineModel getModel() {
        return this.model;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public boolean isStackEvents() {
        return this.stackEvents;
    }

    public void setStackEvents(boolean stackEvents) {
        this.stackEvents = stackEvents;
    }

    public String getEventStyle() {
        return this.eventStyle;
    }

    public void setEventStyle(String eventStyle) {
        this.eventStyle = eventStyle;
    }

    public boolean isAxisOnTop() {
        return this.axisOnTop;
    }

    public void setAxisOnTop(boolean axisOnTop) {
        this.axisOnTop = axisOnTop;
    }

    public boolean isShowCurrentTime() {
        return this.showCurrentTime;
    }

    public void setShowCurrentTime(boolean showCurrentTime) {
        this.showCurrentTime = showCurrentTime;
    }

    public boolean isShowNavigation() {
        return this.showNavigation;
    }

    public void setShowNavigation(boolean showNavigation) {
        this.showNavigation = showNavigation;
    }
}

