/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import org.primefaces.ultima.domain.Car;

@ManagedBean(name="carService")
@ApplicationScoped
public class CarService {
    private static final String[] colors = new String[10];
    private static final String[] brands;

    public List<Car> createCars(int size) {
        ArrayList<Car> list = new ArrayList<Car>();
        for (int i = 0; i < size; ++i) {
            list.add(new Car(this.getRandomId(), this.getRandomBrand(), this.getRandomYear(), this.getRandomColor(), this.getRandomPrice(), this.getRandomSoldState()));
        }
        return list;
    }

    private String getRandomId() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    private int getRandomYear() {
        return (int)(Math.random() * 50.0 + 1960.0);
    }

    private String getRandomColor() {
        return colors[(int)(Math.random() * 10.0)];
    }

    private String getRandomBrand() {
        return brands[(int)(Math.random() * 10.0)];
    }

    private int getRandomPrice() {
        return (int)(Math.random() * 100000.0);
    }

    private boolean getRandomSoldState() {
        return Math.random() > 0.5;
    }

    public List<String> getColors() {
        return Arrays.asList(colors);
    }

    public List<String> getBrands() {
        return Arrays.asList(brands);
    }

    static {
        CarService.colors[0] = "Black";
        CarService.colors[1] = "White";
        CarService.colors[2] = "Green";
        CarService.colors[3] = "Red";
        CarService.colors[4] = "Blue";
        CarService.colors[5] = "Orange";
        CarService.colors[6] = "Silver";
        CarService.colors[7] = "Yellow";
        CarService.colors[8] = "Brown";
        CarService.colors[9] = "Maroon";
        brands = new String[10];
        CarService.brands[0] = "BMW";
        CarService.brands[1] = "Mercedes";
        CarService.brands[2] = "Volvo";
        CarService.brands[3] = "Audi";
        CarService.brands[4] = "Renault";
        CarService.brands[5] = "Fiat";
        CarService.brands[6] = "Volkswagen";
        CarService.brands[7] = "Honda";
        CarService.brands[8] = "Jaguar";
        CarService.brands[9] = "Ford";
    }
}

